/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.FieldSet;
import Freenet.Key;
import Freenet.KeyException;
import Freenet.client.ClientSVK;
import Freenet.client.FreenetURI;
import Freenet.crypt.Util;
import Freenet.crypt.Yarrow;
import Freenet.keys.KSK;
import java.util.Random;

public class ClientKSK
extends ClientSVK {
    public ClientKSK(FreenetURI freenetURI) throws KeyException {
        if (!freenetURI.getKeyType().equals("KSK")) {
            throw new KeyException("URI is not a KSK");
        }
        this.keyData = freenetURI;
    }

    public ClientKSK(Random random, String string) throws KeyException {
        super(random);
        this.keyData = new FreenetURI("KSK", string, null, null);
    }

    public ClientKSK(Random random, FreenetURI freenetURI) throws KeyException {
        super(random);
        if (!freenetURI.getKeyType().equals("KSK")) {
            throw new KeyException("URI is not a KSK");
        }
        this.keyData = freenetURI;
    }

    public byte[] getEncryptionKey(int n) throws KeyException {
        byte[] byArray = null;
        try {
            byArray = this.keyData.getGuessableKey().getBytes("UTF8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        byte[] byArray2 = new byte[n];
        Util.makeKey(byArray, byArray2, 0, byArray2.length);
        this.keyData = new FreenetURI(this.keyData.getKeyType(), this.keyData.getGuessableKey(), this.keyData.getKeyVal(), byArray2);
        return byArray2;
    }

    public Key getKey() {
        this.key = KSK.makeKSK(this.keyData.getGuessableKey(), null);
        this.keyData = new FreenetURI(this.keyData.getKeyType(), this.keyData.getGuessableKey(), this.key.getVal(), this.keyData.getCryptoKey());
        return this.key;
    }

    public Key getKey(FieldSet fieldSet) {
        this.key = KSK.makeKSK(this.keyData.getGuessableKey(), fieldSet);
        this.key.sign(this.contentHash, this.r, fieldSet);
        this.keyData = new FreenetURI(this.keyData.getKeyType(), this.keyData.getGuessableKey(), this.key.getVal(), this.keyData.getCryptoKey());
        return this.key;
    }

    public FreenetURI getURI() {
        return this.keyData;
    }

    public static void main(String[] stringArray) throws Exception {
        ClientKSK clientKSK = new ClientKSK((Random)new Yarrow(), stringArray[0]);
        clientKSK.getKey();
        clientKSK.getEncryptionKey(16);
        System.err.println(clientKSK.getURI());
        FreenetURI freenetURI = new FreenetURI(clientKSK.getURI().toString());
        freenetURI.decompose();
    }

    public String toString() {
        return this.getURI().toString();
    }
}

