/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.Core;
import Freenet.Handshake;
import Freenet.MessageHandler;
import Freenet.MessageObject;
import Freenet.client.ClientCore;
import Freenet.client.ClientMessageObject;
import Freenet.support.Logger;
import java.util.Hashtable;
import java.util.Vector;

public class ClientMessageHandler
implements MessageHandler {
    private ClientCore cc;
    private Hashtable queues;

    public ClientMessageHandler(ClientCore clientCore) {
        this.cc = clientCore;
        this.queues = new Hashtable();
    }

    public void handle(MessageObject messageObject) {
        if (messageObject instanceof Handshake) {
            ((Handshake)messageObject).handle(this.cc);
        } else if (messageObject instanceof ClientMessageObject) {
            MessageQueue messageQueue;
            MessageQueue messageQueue2 = messageQueue = this.getQueue(messageObject.id());
            synchronized (messageQueue2) {
                messageQueue.enqueue((ClientMessageObject)messageObject);
                messageQueue.notify();
            }
        } else {
            Core.logger.log(this, "Got a MessageObject that I can't handle: " + messageObject, Logger.NORMAL);
        }
    }

    public ClientMessageObject getNextReply(long l, long l2) throws InterruptedException {
        ClientMessageObject clientMessageObject;
        MessageQueue messageQueue;
        MessageQueue messageQueue2 = messageQueue = this.getQueue(l);
        synchronized (messageQueue2) {
            long l3 = l2 == 0L ? 0L : System.currentTimeMillis() + l2;
            clientMessageObject = messageQueue.dequeue();
            while (clientMessageObject == null) {
                if (l3 != 0L && System.currentTimeMillis() >= l3) {
                    throw new InterruptedException();
                }
                messageQueue.wait(l2);
                clientMessageObject = messageQueue.dequeue();
            }
        }
        return clientMessageObject;
    }

    public synchronized void removeQueue(long l) {
        Object v = this.queues.remove(new Long(l));
        if (v != null) {
            v.notifyAll();
        }
    }

    private synchronized MessageQueue getQueue(long l) {
        Long l2 = new Long(l);
        Object object = this.queues.get(l2);
        if (object == null) {
            object = new MessageQueue();
            this.queues.put(l2, object);
        }
        return (MessageQueue)object;
    }

    private class MessageQueue
    extends Vector {
        public MessageQueue() {
            super(3);
        }

        public void enqueue(ClientMessageObject clientMessageObject) {
            this.addElement(clientMessageObject);
        }

        public ClientMessageObject dequeue() {
            if (this.size() > 0) {
                Object e = this.firstElement();
                this.removeElementAt(0);
                return (ClientMessageObject)e;
            }
            return null;
        }
    }
}

