/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.FieldSet;
import Freenet.Key;
import Freenet.KeyException;
import Freenet.client.ClientSVK;
import Freenet.client.FreenetURI;
import Freenet.crypt.DSAKeyPair;
import Freenet.crypt.Global;
import Freenet.crypt.Util;
import Freenet.keys.SVK;
import java.util.Random;

public class ClientSSK
extends ClientSVK {
    public ClientSSK(FreenetURI freenetURI) throws KeyException {
        if (!freenetURI.getKeyType().equals("SSK")) {
            throw new KeyException("URI is not a SSK");
        }
        this.key = SVK.makeSVK(freenetURI.getKeyVal(), freenetURI.getGuessableKey());
        this.keyData = freenetURI;
    }

    public ClientSSK(Random random, FreenetURI freenetURI) throws KeyException {
        this.keyData = freenetURI;
        this.kp = new DSAKeyPair(Util.byteArrayToMPI(freenetURI.getKeyVal()), Global.DSAgroupB);
        this.r = random;
        if (!freenetURI.getKeyType().equals("SSK")) {
            throw new KeyException("URI is not an SSK");
        }
    }

    public byte[] getEncryptionKey(int n) throws KeyException {
        byte[] byArray;
        byte[] byArray2 = null;
        try {
            byArray2 = this.keyData.getGuessableKey().getBytes("UTF8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.keyData.getCryptoKey() != null) {
            byArray = this.keyData.getCryptoKey();
            if (byArray.length == 0) {
                byArray = new byte[16];
                this.r.nextBytes(byArray);
                this.keyData = new FreenetURI(this.keyData.getKeyType(), this.keyData.getGuessableKey(), this.keyData.getKeyVal(), byArray);
            }
            byte[] byArray3 = new byte[byArray2.length + this.keyData.getCryptoKey().length];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            System.arraycopy(this.keyData.getCryptoKey(), 0, byArray3, byArray2.length, this.keyData.getCryptoKey().length);
            byArray2 = byArray3;
        }
        byArray = new byte[n];
        Util.makeKey(byArray2, byArray, 0, byArray.length);
        return byArray;
    }

    public Key getKey() {
        return this.key;
    }

    public Key getKey(FieldSet fieldSet) {
        this.key = SVK.makeSVK(this.kp, this.keyData.getGuessableKey(), fieldSet);
        this.key.sign(this.contentHash, this.r, fieldSet);
        return this.key;
    }

    public FreenetURI getURI() {
        byte[] byArray = null;
        if (this.kp != null) {
            byArray = new byte[23];
            byte[] byArray2 = this.kp.fingerprint();
            System.arraycopy(byArray2, 0, byArray, 0, 20);
            byArray[20] = Key.lengthLimit(32768L);
            byArray[21] = (byte)(SVK.keyNumber >> 8);
            byArray[22] = (byte)SVK.keyNumber;
        }
        return new FreenetURI("SSK", this.keyData.getGuessableKey(), byArray == null ? this.keyData.getKeyVal() : byArray, this.keyData.getCryptoKey());
    }
}

