/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.Core;
import Freenet.crypt.BlockCipher;
import Freenet.crypt.CipherInputStream;
import Freenet.crypt.CipherOutputStream;
import Freenet.crypt.DigestOutputStream;
import Freenet.crypt.SHA1;
import Freenet.crypt.Util;
import Freenet.crypt.ciphers.Twofish;
import Freenet.support.Fields;
import Freenet.support.OnExitCleanUp;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.SequenceInputStream;
import java.io.StreamCorruptedException;

public class Document {
    protected long metadatalength;
    protected long doclength;
    protected byte[] encryptionKey;
    protected byte[] contentHash;
    protected InputStream metadata;
    protected InputStream data;

    public Document(InputStream inputStream, byte[] byArray) {
        this(inputStream, null, byArray, -1L, 0L);
    }

    public Document(InputStream inputStream, InputStream inputStream2, byte[] byArray, long l, long l2) {
        this.encryptionKey = byArray;
        this.data = inputStream;
        this.metadata = inputStream2;
        this.metadatalength = l2;
        this.doclength = l;
    }

    public Document(File file, File file2, byte[] byArray) throws IOException {
        this(new FileInputStream(file), new FileInputStream(file2), byArray, file.length(), file2.length());
    }

    public void skipMetadata() throws IOException {
        long l = 0L;
        while (l < this.metadatalength) {
            l += this.metadata.skip(this.metadatalength - l);
        }
    }

    public boolean hasMetadata() {
        return this.metadatalength != 0L;
    }

    public void attachMetadata(InputStream inputStream, long l) {
        this.metadatalength = l;
        this.metadata = inputStream;
    }

    public long length() {
        return (long)(2 + this.encryptionKey.length) + this.metadatalength + this.doclength;
    }

    protected long metadataLength() {
        return this.metadatalength;
    }

    protected long dataLength() {
        return this.doclength;
    }

    protected long documentOffset() {
        return (long)(2 + this.encryptionKey.length) + this.metadatalength;
    }

    public void write(OutputStream outputStream, BlockCipher blockCipher) throws IOException {
        blockCipher.initialize(this.encryptionKey);
        this.write(new CipherOutputStream(blockCipher, outputStream));
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeChar((char)this.encryptionKey.length);
        dataOutputStream.write(this.encryptionKey);
        this.writeMetadata(outputStream);
        this.writeData(outputStream);
    }

    public void writeMetadata(OutputStream outputStream) throws IOException {
        if (this.metadata != null) {
            this.writeData(this.metadata, outputStream, this.metadatalength);
        }
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.data != null) {
            this.writeData(this.data, outputStream, this.doclength);
        }
    }

    protected void writeData(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        byte[] byArray = new byte[65536];
        int n = 0;
        do {
            if ((n = inputStream.read(byArray, 0, (int)Math.min(l, (long)byArray.length))) <= 0) continue;
            l -= (long)n;
            outputStream.write(byArray, 0, n);
        } while (n != -1 && l != 0L);
        outputStream.flush();
    }

    public InputStream toInputStream(BlockCipher blockCipher) throws IOException {
        int n;
        blockCipher.initialize(this.encryptionKey);
        byte[] byArray = new byte[this.encryptionKey.length + 2];
        byArray[0] = (byte)(this.encryptionKey.length >> 8 & 0xFF);
        byArray[1] = (byte)this.encryptionKey.length;
        System.arraycopy(this.encryptionKey, 0, byArray, 2, this.encryptionKey.length);
        SequenceInputStream sequenceInputStream = new SequenceInputStream(new ByteArrayInputStream(byArray), new BufferedInputStream(this.metadata == null ? this.data : new SequenceInputStream(this.metadata, this.data)));
        File file = new File(Util.intToHexString(Core.randSource.nextInt()) + ".tmp");
        OnExitCleanUp.deleteOnExit(file);
        DigestOutputStream digestOutputStream = new DigestOutputStream(new SHA1(), new FileOutputStream(file));
        CipherOutputStream cipherOutputStream = new CipherOutputStream(blockCipher, new BufferedOutputStream(digestOutputStream));
        byte[] byArray2 = new byte[32768];
        for (long i = this.length(); i > 0L; i -= (long)n) {
            n = sequenceInputStream.read(byArray2);
            if (n != -1) {
                cipherOutputStream.write(byArray2, 0, n);
                continue;
            }
            throw new EOFException();
        }
        cipherOutputStream.close();
        this.contentHash = digestOutputStream.getDigest().digest();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        return bufferedInputStream;
    }

    public InputStream toInputStream() throws IOException {
        return this.toInputStream(null);
    }

    public static Document read(InputStream inputStream, long l, long l2) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        char c = dataInputStream.readChar();
        byte[] byArray = new byte[c];
        dataInputStream.readFully(byArray);
        return new Document(inputStream, inputStream, byArray, l, l2);
    }

    public static Document read(InputStream inputStream, byte[] byArray, BlockCipher blockCipher, long l, long l2) throws IOException, StreamCorruptedException {
        blockCipher.initialize(byArray);
        CipherInputStream cipherInputStream = new CipherInputStream(blockCipher, inputStream, false);
        return Document.read(cipherInputStream, byArray, l, l2);
    }

    public static Document read(InputStream inputStream, byte[] byArray, long l, long l2) throws IOException, StreamCorruptedException {
        Document document = Document.read(inputStream, l, l2);
        return document;
    }

    public static void main(String[] stringArray) throws Exception {
        SHA1 sHA1 = new SHA1();
        Twofish twofish = new Twofish();
        byte[] byArray = new byte[twofish.getKeySize() >> 3];
        File file = new File(stringArray[1]);
        if (stringArray[0].equals("create")) {
            byte[] byArray2 = Util.hashFile(sHA1, file);
            System.err.println(Fields.bytesToHex(byArray2, 0, byArray.length));
            Util.makeKey(byArray2, byArray, 0, byArray.length);
            System.err.println(Fields.bytesToHex(byArray, 0, byArray.length));
            FileInputStream fileInputStream = new FileInputStream(file);
            Document document = new Document(fileInputStream, byArray);
            InputStream inputStream = document.toInputStream(twofish);
            byte[] byArray3 = new byte[65536];
            int n = 0;
            PrintStream printStream = System.out;
            do {
                if ((n = inputStream.read(byArray3, 0, byArray3.length)) <= 0) continue;
                ((OutputStream)printStream).write(byArray3, 0, n);
            } while (n != -1);
            ((OutputStream)printStream).flush();
        } else if (stringArray[0].equals("read")) {
            Fields.hexToBytes(stringArray[2], byArray, 0);
            twofish.initialize(byArray);
            Document document = Document.read(new FileInputStream(file), byArray, twofish, 0L, 0L);
            document.writeData(System.out);
        } else if (stringArray[0].equals("encipher")) {
            Util.makeKey(Util.hashFile(sHA1, file), byArray, 0, byArray.length);
            System.err.println(Fields.bytesToHex(byArray, 0, byArray.length));
            FileInputStream fileInputStream = new FileInputStream(file);
            Document document = new Document(fileInputStream, byArray);
            InputStream inputStream = document.toInputStream(twofish);
            int n = 0;
            while (n != -1) {
                n = inputStream.read();
                if (n == -1) continue;
                System.out.write(n);
            }
            System.out.flush();
        }
    }
}

