/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.client.ClientEvent;
import Freenet.client.ClientEventListener;
import Freenet.client.ClientEventProducer;
import Freenet.client.SimpleEventProducer;
import Freenet.client.events.TransferCompletedEvent;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EventInputStream
extends FilterInputStream
implements ClientEventProducer {
    private SimpleEventProducer sep = new SimpleEventProducer();
    private long interval;
    private long read;

    public EventInputStream(InputStream inputStream, long l) {
        super(inputStream);
        this.interval = l;
    }

    public void addEventListener(ClientEventListener clientEventListener) {
        this.sep.addEventListener(clientEventListener);
    }

    public boolean removeEventListener(ClientEventListener clientEventListener) {
        return this.sep.removeEventListener(clientEventListener);
    }

    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.read;
            if (this.interval != 0L && this.read % this.interval == 0L) {
                this.sep.produceEvent(new TransferedEvent(this.read));
            }
        } else {
            this.sep.produceEvent(new TransferCompletedEvent(this.read));
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.read += (long)n3;
            if (this.interval != 0L && (long)n3 > this.interval - this.read % this.interval) {
                this.sep.produceEvent(new TransferedEvent(this.read));
            }
        } else {
            this.sep.produceEvent(new TransferCompletedEvent(this.read));
        }
        return n3;
    }

    public void close() throws IOException {
        this.sep.produceEvent(new TransferCompletedEvent(this.read));
        super.close();
    }

    public static class TransferedEvent
    implements ClientEvent {
        public static final int code = 129;
        private long read;

        protected TransferedEvent(long l) {
            this.read = l;
        }

        public long getProgress() {
            return this.read;
        }

        public String getDescription() {
            return this.read + " bytes read.";
        }

        public int getCode() {
            return 129;
        }
    }
}

