/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.client.Base64;
import Freenet.client.IllegalBase64Exception;
import Freenet.support.Fields;
import java.net.MalformedURLException;

public class FreenetURI {
    private String keyType;
    private String guessableName;
    private byte[] keyVal;
    private byte[] cryptoKeyVal;

    public FreenetURI(String string, String string2, byte[] byArray, byte[] byArray2) {
        this.keyType = string.trim().toUpperCase();
        this.guessableName = string2;
        this.keyVal = byArray;
        this.cryptoKeyVal = byArray2;
    }

    public FreenetURI(String string) throws MalformedURLException {
        string = FreenetURI.urlDecode(string);
        int n = string.indexOf(58);
        int n2 = string.indexOf(64);
        if (n != -1 && !string.substring(0, n).equalsIgnoreCase("freenet")) {
            throw new MalformedURLException("Invalid protocol for Freenet URI");
        }
        if (n2 == -1) {
            this.keyType = "KSK";
            n2 = n;
        } else {
            this.keyType = string.substring(n + 1, n2).toUpperCase().trim();
        }
        this.parseKey(string.substring(n2 == -1 ? Math.max(n + 1, 0) : n2 + 1));
    }

    protected void parseKey(String string) throws MalformedURLException {
        block9: {
            try {
                if ("KSK".equals(this.keyType)) {
                    this.guessableName = string;
                    break block9;
                }
                if ("SVK".equals(this.keyType) || "CHK".equals(this.keyType)) {
                    int n = string.indexOf(44);
                    if (n == -1) {
                        return;
                    }
                    this.keyVal = Base64.decode(string.substring(0, n));
                    this.cryptoKeyVal = Base64.decode(string.substring(n + 1));
                    break block9;
                }
                if ("SSK".equals(this.keyType)) {
                    int n = string.indexOf(44);
                    int n2 = string.indexOf(47);
                    if (n != -1) {
                        this.cryptoKeyVal = Base64.decode(string.substring(n + 1, n2));
                    } else {
                        n = n2;
                    }
                    if (n2 < 1) {
                        throw new MalformedURLException("Malformed SSK");
                    }
                    this.guessableName = string.substring(n2 + 1);
                    this.keyVal = Base64.decode(string.substring(0, n));
                    break block9;
                }
                throw new MalformedURLException("Invalid or unknown keytype");
            }
            catch (IllegalBase64Exception illegalBase64Exception) {
                throw new MalformedURLException("Invalid Base64 quantity: " + illegalBase64Exception);
            }
        }
    }

    protected void decompose() {
        System.out.println("Keytype: " + this.keyType);
        System.out.println("Keyval : " + (this.keyVal == null ? "none" : Fields.bytesToHex(this.keyVal, 0, this.keyVal.length)));
        System.out.println("Dc. Key: " + (this.cryptoKeyVal == null ? "none" : Fields.bytesToHex(this.cryptoKeyVal, 0, this.cryptoKeyVal.length)));
        System.out.println("Guess  : " + (this.guessableName == null ? "none" : this.guessableName));
    }

    public String getGuessableKey() {
        return this.guessableName;
    }

    public byte[] getKeyVal() {
        return this.keyVal;
    }

    public byte[] getCryptoKey() {
        return this.cryptoKeyVal;
    }

    public String getKeyType() {
        return this.keyType;
    }

    protected static String urlDecode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '+') {
                stringBuffer.append(' ');
            } else if (string.charAt(n) == '%') {
                int n2 = Integer.parseInt(string.substring(n + 1, n + 3), 16);
                stringBuffer.append((char)n2);
                n += 2;
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected static String urlEncode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == ' ') {
                stringBuffer.append('+');
            } else if (string.charAt(n) > '\u0080' || string.charAt(n) < ',') {
                stringBuffer.append('%').append(Integer.toString(string.charAt(n), 16));
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toURI() {
        return this.toString(true);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("freenet:");
        stringBuffer.append(this.keyType);
        if (bl) {
            stringBuffer.append("%40");
        } else {
            stringBuffer.append('@');
        }
        if ("KSK".equals(this.keyType)) {
            stringBuffer.append(FreenetURI.urlEncode(this.guessableName));
        } else if ("SSK".equals(this.keyType)) {
            stringBuffer.append(Base64.encode(this.keyVal));
            if (this.cryptoKeyVal != null) {
                stringBuffer.append(',').append(Base64.encode(this.cryptoKeyVal));
            }
            stringBuffer.append('/').append(FreenetURI.urlEncode(this.guessableName));
        } else {
            if (this.keyVal != null) {
                stringBuffer.append(Base64.encode(this.keyVal));
                if (this.cryptoKeyVal != null) {
                    stringBuffer.append(',').append(Base64.encode(this.cryptoKeyVal));
                }
            }
            if (this.guessableName != null) {
                stringBuffer.append(this.guessableName);
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        FreenetURI freenetURI = new FreenetURI(stringArray[0]);
        freenetURI.decompose();
        System.err.println(freenetURI);
    }
}

