/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.Core;
import Freenet.KeyException;
import Freenet.Params;
import Freenet.client.Base64;
import Freenet.client.CLI;
import Freenet.client.Client;
import Freenet.client.ClientCHK;
import Freenet.client.ClientCollisionListener;
import Freenet.client.ClientKSK;
import Freenet.client.ClientKey;
import Freenet.client.ClientSSK;
import Freenet.client.ClientSVK;
import Freenet.client.ClientUtil;
import Freenet.client.DoneListener;
import Freenet.client.EventLogger;
import Freenet.client.FreenetURI;
import Freenet.client.RequestToken;
import Freenet.support.Bucket;
import Freenet.support.FileBucket;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Random;

public class InsertClient
extends CLI {
    static /* synthetic */ Class class$Freenet$client$ClientSVK;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        block11: {
            block12: {
                Params params = new Params(stringArray);
                CLI.exitState = 1;
                try {
                    try {
                        InsertClient insertClient = new InsertClient(params);
                        if (params.getNumArgs() < 1) {
                            insertClient.usage();
                            CLI.exitState = 1;
                            break block11;
                        }
                        boolean bl = false;
                        String string = params.getArg(0);
                        String string2 = params.getNumArgs() > 1 ? params.getArg(1) : null;
                        String string3 = params.getParam("metadata");
                        String string4 = params.getParam("redirect");
                        boolean bl2 = params.getboolean("autoRedirect", true);
                        if (string4 != null) {
                            if (params.getNumArgs() > 1) {
                                insertClient.usage();
                                CLI.exitState = 1;
                                Object var11_13 = null;
                                break block12;
                            }
                            File file = ClientUtil.makeRedirect(new FreenetURI(string4));
                            string3 = file.getCanonicalPath();
                            bl = true;
                        }
                        insertClient.execute(string, string2, string3, bl, bl2);
                        break block11;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.err.println(illegalArgumentException.getMessage());
                        CLI.exitState = 1;
                        Object var11_15 = null;
                        CLI.waitForThreadsAndExit();
                        return;
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.err.println("Could not parse URL");
                        CLI.exitState = 1;
                        Object var11_16 = null;
                        CLI.waitForThreadsAndExit();
                        return;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.println("File not found");
                        CLI.exitState = 1;
                        Object var11_17 = null;
                        CLI.waitForThreadsAndExit();
                        return;
                    }
                    catch (IOException iOException) {
                        System.err.println("Error while reading file: " + iOException.getMessage());
                        CLI.exitState = 1;
                        Object var11_18 = null;
                        CLI.waitForThreadsAndExit();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_19 = null;
                    CLI.waitForThreadsAndExit();
                    throw throwable;
                }
            }
            CLI.waitForThreadsAndExit();
            return;
        }
        Object var11_14 = null;
        CLI.waitForThreadsAndExit();
    }

    public InsertClient(Params params) throws IllegalArgumentException {
        super(params);
    }

    public FreenetURI execute(String string, String string2) throws MalformedURLException, FileNotFoundException, IOException {
        return this.execute(string, string2, null, false, true);
    }

    public FreenetURI execute(String string, String string2, String string3, boolean bl) throws MalformedURLException, FileNotFoundException, IOException {
        return this.execute(string, string2, string3, bl, true);
    }

    public FreenetURI execute(String string, String string2, String string3, boolean bl, boolean bl2) throws MalformedURLException, FileNotFoundException, IOException {
        Object object;
        Object object2;
        Bucket bucket;
        if (string2 != null) {
            bucket = new FileBucket(new File(string2));
        } else {
            bucket = this.getBucket();
            object2 = bucket.getOutputStream();
            if (!bl) {
                object = new byte[Core.bufferSize];
                int n = System.in.read((byte[])object);
                while (n != -1) {
                    ((OutputStream)object2).write((byte[])object, 0, n);
                    n = System.in.read((byte[])object);
                }
            }
            ((OutputStream)object2).close();
        }
        Bucket bucket2 = string3 != null ? new FileBucket(new File(string3)) : this.getBucket();
        object2 = new FreenetURI(string);
        if (bl || !bl2 || ((FreenetURI)object2).getKeyType().equals("CHK")) {
            return this.dumpBuckets((FreenetURI)object2, bucket, bucket2);
        }
        object = this.dumpBuckets("CHK@", bucket, bucket2);
        FileBucket fileBucket = ClientUtil.makeRedirectBucket((FreenetURI)object);
        return this.dumpBuckets((FreenetURI)object2, (Bucket)new FileBucket(), (Bucket)fileBucket);
    }

    public FreenetURI dumpBuckets(String string, Bucket bucket, Bucket bucket2) throws MalformedURLException, IOException {
        return this.dumpBuckets(new FreenetURI(string), bucket, bucket2);
    }

    public FreenetURI dumpBuckets(FreenetURI freenetURI, Bucket bucket, Bucket bucket2) throws MalformedURLException, IOException {
        RequestToken requestToken;
        ClientKey clientKey;
        Client client = new Client(this.cc, this.target);
        if (freenetURI.getKeyType().equals("CHK")) {
            clientKey = new ClientCHK(bucket.getInputStream(), bucket.size());
        } else if (freenetURI.getKeyType().equals("KSK")) {
            clientKey = new ClientKSK((Random)Core.randSource, freenetURI.getGuessableKey());
            System.out.println("KSK: " + clientKey);
        } else if (freenetURI.getKeyType().equals("SVK")) {
            clientKey = new ClientSVK(Core.randSource);
        } else if (freenetURI.getKeyType().equals("SSK")) {
            clientKey = new ClientSSK((Random)Core.randSource, freenetURI);
        } else {
            throw new KeyException("Unsupported keytype in URI");
        }
        if (clientKey instanceof ClientSVK && bucket2.size() + bucket.size() > 32768L) {
            System.err.println("SVKs, KSKs, and SSKs cannot be more than 32,768 bytes.");
            System.err.println("\nInstead, insert your file as a CHK, then insert a redirect from the");
            System.err.println("SVK/KSK/SSK to the resulting CHK.");
            CLI.exitState = 1;
            return clientKey.getURI();
        }
        InputStream inputStream = bucket.getInputStream();
        InputStream inputStream2 = bucket2.getInputStream();
        DoneListener doneListener = new DoneListener();
        ClientCollisionListener clientCollisionListener = new ClientCollisionListener();
        System.out.println("entering syncronized space");
        DoneListener doneListener2 = doneListener;
        synchronized (doneListener2) {
            requestToken = client.prepare(this.htl, inputStream, bucket.size(), inputStream2, bucket2.size(), clientKey, this.cipherName, this.getBucket());
            requestToken.addEventListener(clientCollisionListener);
            requestToken.addEventListener(new EventLogger(Core.logger));
            requestToken.addEventListener(doneListener);
            client.makeRequest(requestToken);
            try {
                doneListener.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (requestToken.state() < 4) {
            Exception[] exceptionArray = doneListener.getExceptions();
            if (exceptionArray == null) {
                System.err.println("Insert failed gracefully.");
                if (clientKey instanceof ClientCHK && clientCollisionListener.collisionHappened()) {
                    System.err.println("An exact copy of the data you tried to insert was already present.");
                    CLI.exitState = 0;
                    return clientKey.getURI();
                }
            } else {
                System.err.println("Encountered the following exceptions while trying to Insert:");
                int n = 0;
                while (n < exceptionArray.length) {
                    exceptionArray[n].printStackTrace(System.err);
                    ++n;
                }
            }
            CLI.exitState = 1;
            return null;
        }
        FreenetURI freenetURI2 = clientKey.getURI();
        System.err.println("Inserted Key   : " + clientKey.getURI());
        if (clientKey.getClass() == (class$Freenet$client$ClientSVK == null ? (class$Freenet$client$ClientSVK = InsertClient.class$("Freenet.client.ClientSVK")) : class$Freenet$client$ClientSVK)) {
            ClientSVK clientSVK = (ClientSVK)clientKey;
            System.err.println("SVK private key: " + Base64.encode(clientSVK.key.getKeyPair().getX().toByteArray()));
            System.err.println("Hang on to this key if you wish to update it in the future, or if you wish to\ninsert subspace keys (SSKs) under this SVK root.");
        }
        CLI.exitState = 0;
        return clientKey.getURI();
    }

    public void usage() {
        System.out.println("Usage: freenet_insert URL [input-file]");
        System.out.println("");
        System.out.println("  -length bytes              Bytes to insert (if reading stdin)");
        System.out.println("  -metadata file             Attach private metadata to the document");
        System.out.println("  -redirect URI              Create a redirect from this key to another");
        System.out.println("                             (cannot be used with [input-file]");
        System.out.println("  -autoRedirect yes|no       Redirects URI to a CHK if set automatically.");
        System.out.println("                             Using redirect negates this value.");
        System.out.println("  -cipher cipher-name        Use 'cipher-name' as the cipher");
        System.out.println("                             Choices are 'Twofish' (default) or 'Rijndael'");
        System.out.println("  -listenPort port           Local port to listen for replies on");
        System.out.println("  -safer yes|no              Avoid unnecessary risk by encrypting all data");
        System.out.println("                             written to disk. Slow and not perfect. Default off.");
        System.out.println("  -serverAddress address     Server node to connect to");
        System.out.println("  -htl hops-to-live          Hops-to-live for request");
        System.out.println("  -logging error|normal      Logging level");
        System.out.println("           |minor|debugging");
        System.out.println("  -verbosity 0-5             Verbosity of log messages");
        System.out.println("");
        System.out.println("Examples:");
        System.out.println("  freenet_insert test-key test.txt");
        System.out.println("  freenet_insert freenet:KSK@test-key test.txt");
        System.out.println("  freenet_insert freenet:CHK@ test.txt");
        System.out.println();
        System.out.println("Send bug reports to freenet-dev@lists.sourceforge.net");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

