/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.Core;
import Freenet.FieldSet;
import Freenet.Params;
import Freenet.client.CLI;
import Freenet.client.Client;
import Freenet.client.ClientKey;
import Freenet.client.ClientUtil;
import Freenet.client.DoneListener;
import Freenet.client.EventLogger;
import Freenet.client.FreenetURI;
import Freenet.client.NoDataException;
import Freenet.client.RequestToken;
import Freenet.support.Bucket;
import Freenet.support.FileBucket;
import Freenet.support.io.ReadInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;

public class RequestClient
extends CLI {
    protected boolean autoRedirect = true;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws Exception {
        Params params = new Params(stringArray);
        CLI.exitState = 1;
        try {
            try {
                RequestClient requestClient = new RequestClient(params);
                if (params.getNumArgs() < 1) {
                    requestClient.usage();
                    CLI.exitState = 1;
                }
                String string = params.getArg(0);
                String string2 = params.getParam("metadata");
                requestClient.autoRedirect = params.getboolean("autoRedirect", true);
                if (params.getNumArgs() > 1) {
                    requestClient.execute(string, params.getArg(1), string2);
                }
                requestClient.execute(string, null, string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println(illegalArgumentException.getMessage());
                CLI.exitState = 1;
                Object var6_8 = null;
                CLI.waitForThreadsAndExit();
                return;
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Could not parse the provided URL");
                CLI.exitState = 1;
                Object var6_9 = null;
                CLI.waitForThreadsAndExit();
                return;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            CLI.waitForThreadsAndExit();
            throw throwable;
        }
        CLI.waitForThreadsAndExit();
    }

    public RequestClient(Params params) {
        super(params);
    }

    public void execute(String string, String string2) throws MalformedURLException {
        this.execute(string, string2, null);
    }

    public void execute(String string, String string2, String string3) throws MalformedURLException {
        Bucket bucket = string2 != null ? new FileBucket(new File(string2)) : this.getBucket();
        Bucket bucket2 = string3 != null ? new FileBucket(new File(string3)) : this.getBucket();
        this.execute(string, string2, string3, bucket, bucket2);
    }

    protected void execute(String string, String string2, String string3, Bucket bucket, Bucket bucket2) throws MalformedURLException {
        int n;
        int n2;
        Object[] objectArray;
        Closeable closeable;
        boolean bl = false;
        try {
            bl = this.fillBuckets(string, bucket, bucket2);
        }
        catch (IOException iOException) {
            System.err.println("Error reading stream.");
            CLI.exitState = 1;
            return;
        }
        catch (NoDataException noDataException) {
            System.err.println("Error, finished but received no data.");
            CLI.exitState = 1;
            return;
        }
        if (!bl) {
            return;
        }
        if (string3 == null && bucket2.size() > 0L) {
            try {
                closeable = new InputStreamReader(bucket2.getInputStream());
                objectArray = new char[Core.bufferSize >> 1];
                System.out.println("Metadata:");
                n2 = 0;
                n = 0;
                while ((long)n2 < bucket2.size()) {
                    n = ((Reader)closeable).read((char[])objectArray);
                    n2 += n;
                    System.out.print(new String((char[])objectArray, 0, n));
                }
            }
            catch (IOException iOException) {
                System.err.println("Error, failed to read metadata file");
            }
        }
        if (string2 == null && bucket.size() > 0L) {
            try {
                closeable = bucket.getInputStream();
                objectArray = new byte[Core.bufferSize];
                System.out.println("Data:");
                n2 = 0;
                while ((long)n2 < bucket.size()) {
                    n = ((InputStream)closeable).read((byte[])objectArray);
                    n2 += n;
                    System.out.write((byte[])objectArray, 0, n);
                }
            }
            catch (IOException iOException) {
                CLI.exitState = 1;
                return;
            }
        }
        CLI.exitState = 0;
    }

    public boolean fillBuckets(String string, Bucket bucket, Bucket bucket2) throws MalformedURLException, IOException, NoDataException {
        RequestToken requestToken;
        Exception[] exceptionArray;
        DoneListener doneListener;
        Client client = new Client(this.cc, this.target);
        DoneListener doneListener2 = doneListener = new DoneListener();
        synchronized (doneListener2) {
            exceptionArray = ClientUtil.getKey(string);
            requestToken = client.prepare(this.htl, (ClientKey)exceptionArray, bucket, bucket2);
            requestToken.addEventListener(new EventLogger(Core.logger));
            requestToken.addEventListener(doneListener);
            client.makeRequest(requestToken);
            try {
                doneListener.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (requestToken.state() < 4) {
            exceptionArray = doneListener.getExceptions();
            if (exceptionArray == null) {
                System.err.println("Request failed gracefully.");
            } else {
                System.err.println("Encountered the following exceptions while attempting to Request:");
                int n = 0;
                while (n < exceptionArray.length) {
                    exceptionArray[n].printStackTrace(System.err);
                    ++n;
                }
            }
            CLI.exitState = 1;
            return false;
        }
        if (bucket.size() == 0L && bucket2.size() == 0L) {
            throw new NoDataException();
        }
        if (bucket.size() == 0L && bucket2.size() > 0L) {
            this.handleControlDoc(bucket, bucket2);
        }
        return true;
    }

    public void handleControlDoc(Bucket bucket, Bucket bucket2) throws IOException, NoDataException {
        ReadInputStream readInputStream = new ReadInputStream(bucket2.getInputStream());
        String string = readInputStream.readTo('\n', '\r');
        FieldSet fieldSet = new FieldSet();
        fieldSet.parseFields(readInputStream);
        this.handleControlDoc(string, fieldSet, readInputStream, bucket, bucket2);
    }

    protected void handleControlDoc(String string, FieldSet fieldSet, ReadInputStream readInputStream, Bucket bucket, Bucket bucket2) throws IOException, NoDataException {
        if ("Redirect".equals(string)) {
            FreenetURI freenetURI = new FreenetURI(readInputStream.readTo('\n', '\r'));
            bucket2.resetWrite();
            System.err.println("Redirect to: " + freenetURI);
            if (this.autoRedirect) {
                this.fillBuckets(freenetURI.toString(), bucket, bucket2);
            }
        }
    }

    public void usage() {
        System.out.println("Usage: freenet_request URL output-file");
        System.out.println("");
        System.out.println("  -metadata file             Save private metadata in 'file'");
        System.out.println("  -autoRedirect yes|no       Follows redirects automatically. Default on.");
        System.out.println("  -cipher cipher-name        Use 'cipher-name' as the cipher");
        System.out.println("                             Choices are 'Twofish' (default) or 'Rijndael'");
        System.out.println("  -listenPort port           Local port to listen for replies on");
        System.out.println("  -safer yes|no              Avoid unnecessary risk by encrypting all data");
        System.out.println("                             written to disk. Slow and not perfect. Default off.");
        System.out.println("  -serverAddress address     Server node to connect to");
        System.out.println("  -htl hops-to-live          Hops-to-live for request");
        System.out.println("  -logging error|normal      Logging level");
        System.out.println("           |minor|debugging");
        System.out.println("  -verbosity 0-5             Verbosity of log messages");
        System.out.println("");
        System.out.println("Examples:");
        System.out.println("  freenet_request test-key test.txt");
        System.out.println("  freenet_request freenet:KSK@test-key test.txt");
        System.out.println("  freenet_request freenet:CHK@yoZOL0nrUhqIdGPjCYjgwhTJQAEDAQ,cH4oZkbe");
        System.out.println("                  HS5wJijKBtKuPA test.txt");
        System.out.println();
        System.out.println("Send bug reports to freenet-dev@lists.sourceforge.net");
    }
}

