/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.client.ClientEvent;
import Freenet.client.ClientEventListener;
import Freenet.client.events.ExceptionEvent;
import Freenet.client.events.SegmentCompleteEvent;
import Freenet.client.events.StateReachedEvent;
import java.util.Stack;

public class SegmentCompleteListener
implements ClientEventListener {
    private Stack exceptions = new Stack();
    private boolean isComplete = false;

    public void waitEvent() throws InterruptedException {
        SegmentCompleteListener segmentCompleteListener = this;
        synchronized (segmentCompleteListener) {
            while (!this.isComplete) {
                this.wait();
            }
        }
    }

    public void receive(ClientEvent clientEvent) {
        if (clientEvent instanceof SegmentCompleteEvent) {
            SegmentCompleteListener segmentCompleteListener = this;
            synchronized (segmentCompleteListener) {
                this.isComplete = true;
                this.notifyAll();
            }
        }
        if (clientEvent instanceof StateReachedEvent) {
            int n = ((StateReachedEvent)clientEvent).getState();
            if (n == 4 || n == -1) {
                SegmentCompleteListener segmentCompleteListener = this;
                synchronized (segmentCompleteListener) {
                    this.isComplete = true;
                    this.notifyAll();
                }
            }
        } else if (clientEvent instanceof ExceptionEvent) {
            try {
                ((ExceptionEvent)clientEvent).rethrow();
            }
            catch (Exception exception) {
                this.exceptions.push(exception);
            }
        }
    }
}

