/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.Connection;
import Freenet.Core;
import Freenet.ListenException;
import Freenet.Listener;
import Freenet.ListenerFactory;
import Freenet.ListeningAddress;
import Freenet.client.ServletConnectionHandler;
import Freenet.client.ServletConstructor;
import Freenet.servlet.Servlet;
import Freenet.support.Logger;
import java.io.IOException;

public class ServletHandler
extends Thread {
    private Listener listener;
    private ServletConstructor constructor;
    public boolean listen = true;

    public ServletHandler(ThreadGroup threadGroup, String string, ListeningAddress listeningAddress, ServletConstructor servletConstructor) throws ListenException {
        super(threadGroup, string);
        this.listener = ListenerFactory.listen(listeningAddress);
        this.constructor = servletConstructor;
    }

    public ServletHandler(ListeningAddress listeningAddress, ServletConstructor servletConstructor) throws ListenException {
        this.listener = ListenerFactory.listen(listeningAddress);
        this.constructor = servletConstructor;
    }

    public void run() {
        this.acceptConnections();
    }

    public void acceptConnections() {
        while (this.listen) {
            Connection connection;
            try {
                connection = this.listener.accept();
                Core.logger.log(this, "Accepted connection:" + connection, Logger.MINOR);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new RuntimeException("Problem accepting next connection:" + iOException);
            }
            Servlet servlet = null;
            try {
                servlet = this.constructor.newInstance();
            }
            catch (Exception exception) {
                Core.logger.log(this, "Could not instantiation servlet: " + exception, Logger.ERROR);
                return;
            }
            ServletConnectionHandler servletConnectionHandler = new ServletConnectionHandler(connection, servlet);
            servletConnectionHandler.start();
        }
    }
}

