/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.Conduit;
import Freenet.Core;
import Freenet.FieldSet;
import Freenet.KeyException;
import Freenet.Params;
import Freenet.client.Base64;
import Freenet.client.CLI;
import Freenet.client.Client;
import Freenet.client.ClientCHK;
import Freenet.client.ClientCollisionListener;
import Freenet.client.ClientKSK;
import Freenet.client.ClientKey;
import Freenet.client.ClientSSK;
import Freenet.client.ClientSVK;
import Freenet.client.ClientUtil;
import Freenet.client.DoneListener;
import Freenet.client.EventLogger;
import Freenet.client.FreenetURI;
import Freenet.client.NoDataException;
import Freenet.client.RequestToken;
import Freenet.client.SegmentCompleteListener;
import Freenet.client.TransferStartedListener;
import Freenet.client.events.TransferStartedEvent;
import Freenet.support.Bucket;
import Freenet.support.FileBucket;
import Freenet.support.Logger;
import Freenet.support.NullBucket;
import Freenet.support.Pair;
import Freenet.support.PipedBucket;
import Freenet.support.StringUtils;
import Freenet.support.io.ReadInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Random;

public class SimplifiedClient
extends CLI {
    boolean autoRedirect;
    Logger logger = null;
    static /* synthetic */ Class class$Freenet$client$ClientSVK;

    public static void main(String[] stringArray) throws Exception {
        SimplifiedClient simplifiedClient = new SimplifiedClient(new Params(stringArray));
        PipedBucket pipedBucket = new PipedBucket();
        FileBucket fileBucket = new FileBucket(new File("meta"));
        simplifiedClient.getData(stringArray[0], pipedBucket, fileBucket);
        InputStream inputStream = pipedBucket.getInputStream();
        Conduit conduit = new Conduit(inputStream, System.out, null);
        conduit.run();
    }

    public SimplifiedClient() {
        this(new Params());
    }

    public SimplifiedClient(Params params) {
        this(params, Core.logger);
        Core.init(params);
    }

    public SimplifiedClient(Params params, Logger logger) {
        super(params, logger, true);
        this.autoRedirect = params.getboolean("autoRedirect", true);
    }

    public Logger getLogger() {
        return this.logger != null ? this.logger : Core.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Pair get(String string) throws MalformedURLException, IOException, NoDataException {
        PipedBucket pipedBucket = new PipedBucket();
        FileBucket fileBucket = new FileBucket();
        this.getData(string, pipedBucket, fileBucket);
        return new Pair(pipedBucket, fileBucket);
    }

    public void get(String string, String string2, String string3) throws IOException, MalformedURLException, NoDataException {
        FileBucket fileBucket = new FileBucket(new File(string2));
        Bucket bucket = null;
        bucket = string3 == null ? new PipedBucket() : new FileBucket(new File(string3));
        this.getData(string, fileBucket, bucket);
    }

    public String put(String string, String string2) throws IOException {
        return this.put(new FileBucket(new File(string)), new FileBucket(new File(string2)));
    }

    public String put(Bucket bucket, Bucket bucket2) throws IOException {
        try {
            return this.put("freenet:CHK@", bucket, bucket2);
        }
        catch (MalformedURLException malformedURLException) {
            this.getLogger().log(this, "SimplifiedClient is broken. freenet:CHK@ is reported as an invalid URI.", Logger.ERROR);
            return null;
        }
    }

    public String put(String string, String string2, String string3) throws IOException, MalformedURLException {
        Bucket bucket = null;
        Bucket bucket2 = null;
        bucket = string2 != null ? new FileBucket(new File(string2)) : new NullBucket();
        bucket2 = string3 != null ? new FileBucket(new File(string3)) : new NullBucket();
        return this.put(string, bucket, bucket2);
    }

    public String put(String string, Bucket bucket, Bucket bucket2) throws IOException, MalformedURLException {
        boolean bl = false;
        String string2 = (String)StringUtils.split(string, '@').elementAt(0);
        if (string2.equals("CHK") || !this.autoRedirect || bucket == null) {
            FreenetURI freenetURI = this.dumpBuckets(string, bucket, bucket2);
            return freenetURI == null ? null : freenetURI.toString();
        }
        FreenetURI freenetURI = this.dumpBuckets("freenet:CHK@", bucket, bucket2);
        return freenetURI == null ? null : this.putRedirect(string, freenetURI.toString());
    }

    public String putRedirect(String string, String string2) throws IOException {
        FileBucket fileBucket = ClientUtil.makeRedirectBucket(new FreenetURI(string2));
        FreenetURI freenetURI = this.dumpBuckets(string, (Bucket)new NullBucket(), (Bucket)fileBucket);
        if (fileBucket instanceof FileBucket) {
            fileBucket.getFile().delete();
        }
        return freenetURI == null ? null : freenetURI.toString();
    }

    public void getLatest(String string, String string2) {
    }

    protected String randFilename() {
        return "t" + Math.abs(new Random().nextInt() % 10000);
    }

    public void getData(String string, Bucket bucket, Bucket bucket2) throws MalformedURLException, IOException, NoDataException, FileNotFoundException {
        this.fillBuckets(string, bucket, bucket2, true);
    }

    public void getMetadata(String string, Bucket bucket, Bucket bucket2) throws MalformedURLException, IOException, NoDataException, FileNotFoundException {
        this.fillBuckets(string, bucket, bucket2, false);
    }

    public void fillBuckets(String string, Bucket bucket, Bucket bucket2, boolean bl) throws MalformedURLException, IOException, NoDataException, FileNotFoundException {
        Client client = new Client(this.cc, this.target);
        DoneListener doneListener = new DoneListener();
        SegmentCompleteListener segmentCompleteListener = new SegmentCompleteListener();
        TransferStartedListener transferStartedListener = new TransferStartedListener();
        ClientKey clientKey = ClientUtil.getKey(string);
        RequestToken requestToken = client.prepare(this.htl, clientKey, bucket, bucket2);
        requestToken.addEventListener(new EventLogger(Core.logger));
        requestToken.addEventListener(doneListener);
        requestToken.addEventListener(segmentCompleteListener);
        requestToken.addEventListener(transferStartedListener);
        client.makeRequest(requestToken);
        TransferStartedListener transferStartedListener2 = transferStartedListener;
        synchronized (transferStartedListener2) {
            try {
                transferStartedListener.waitEvent();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        TransferStartedEvent transferStartedEvent = transferStartedListener.event;
        if (transferStartedEvent == null) {
            throw new FileNotFoundException();
        }
        long l = transferStartedEvent.getDataLength();
        long l2 = transferStartedEvent.getMetadataLength();
        if (l == 0L && l2 == 0L) {
            throw new NoDataException();
        }
        if (l == 0L && l2 > 0L) {
            DoneListener doneListener2 = doneListener;
            synchronized (doneListener2) {
                try {
                    doneListener.waitEvent();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.handleControlDoc(bucket, bucket2, bl);
            return;
        }
        if (bl) {
            DoneListener doneListener3 = doneListener;
            synchronized (doneListener3) {
                try {
                    doneListener.waitEvent();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (l2 > 0L) {
            SegmentCompleteListener segmentCompleteListener2 = segmentCompleteListener;
            synchronized (segmentCompleteListener2) {
                try {
                    segmentCompleteListener.waitEvent();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void handleControlDoc(Bucket bucket, Bucket bucket2, boolean bl) throws IOException, NoDataException {
        ReadInputStream readInputStream = new ReadInputStream(bucket2.getInputStream());
        String string = readInputStream.readTo('\n', '\r');
        FieldSet fieldSet = new FieldSet();
        fieldSet.parseFields(readInputStream);
        if ("Redirect".equals(string)) {
            FreenetURI freenetURI = new FreenetURI(readInputStream.readTo('\n', '\r'));
            bucket.resetWrite();
            bucket2.resetWrite();
            this.getLogger().log(this, "Redirect to: " + freenetURI, Logger.MINOR);
            if (this.autoRedirect) {
                this.fillBuckets(freenetURI.toString(), bucket, bucket2, bl);
            }
        }
    }

    public FreenetURI dumpBuckets(String string, Bucket bucket, Bucket bucket2) throws MalformedURLException, IOException {
        return this.dumpBuckets(new FreenetURI(string), bucket, bucket2);
    }

    public FreenetURI dumpBuckets(FreenetURI freenetURI, Bucket bucket, Bucket bucket2) throws MalformedURLException, IOException {
        RequestToken requestToken;
        Client client = new Client(this.cc, this.target);
        ClientKey clientKey = this.makeClientKey(freenetURI, bucket);
        InputStream inputStream = bucket.getInputStream();
        InputStream inputStream2 = bucket2.getInputStream();
        DoneListener doneListener = new DoneListener();
        ClientCollisionListener clientCollisionListener = new ClientCollisionListener();
        FileBucket fileBucket = new FileBucket();
        DoneListener doneListener2 = doneListener;
        synchronized (doneListener2) {
            requestToken = client.prepare(this.htl, inputStream, bucket.size(), inputStream2, bucket2.size(), clientKey, this.cipherName, fileBucket);
            requestToken.addEventListener(clientCollisionListener);
            requestToken.addEventListener(new EventLogger(this.getLogger()));
            requestToken.addEventListener(doneListener);
            client.makeRequest(requestToken);
            try {
                doneListener.waitEvent();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        fileBucket.getFile().delete();
        if (requestToken.state() < 4) {
            Exception[] exceptionArray = doneListener.getExceptions();
            if (exceptionArray == null) {
                this.getLogger().log(this, "Insert failed gracefully.", Logger.NORMAL);
                if (clientKey instanceof ClientCHK && clientCollisionListener.collisionHappened()) {
                    this.getLogger().log(this, "An exact copy of the data you tried to insert was already present.", Logger.NORMAL);
                    return clientKey.getURI();
                }
            } else {
                this.getLogger().log(this, "Encountered the following exceptions while trying to Insert:", Logger.ERROR);
                int n = 0;
                while (n < exceptionArray.length) {
                    exceptionArray[n].printStackTrace(this.getLogger().getOut());
                    ++n;
                }
            }
            return null;
        }
        FreenetURI freenetURI2 = clientKey.getURI();
        this.getLogger().log(this, "Inserted Key   : " + clientKey.getURI(), Logger.NORMAL);
        if (clientKey.getClass() == (class$Freenet$client$ClientSVK == null ? (class$Freenet$client$ClientSVK = SimplifiedClient.class$("Freenet.client.ClientSVK")) : class$Freenet$client$ClientSVK)) {
            ClientSVK clientSVK = (ClientSVK)clientKey;
            this.getLogger().log(this, "SVK private key: " + Base64.encode(clientSVK.key.getKeyPair().getX().toByteArray()), Logger.NORMAL);
            this.getLogger().log(this, "Hang on to this key if you wish to update it in the future, or if you wish to\ninsert subspace keys (SSKs) under this SVK root.", Logger.NORMAL);
        }
        CLI.exitState = 0;
        return clientKey.getURI();
    }

    private ClientKey makeClientKey(FreenetURI freenetURI, Bucket bucket) throws KeyException, IOException {
        if (freenetURI.getKeyType().equals("CHK")) {
            return new ClientCHK(bucket.getInputStream(), bucket.size());
        }
        if (freenetURI.getKeyType().equals("KSK")) {
            return new ClientKSK((Random)Core.randSource, freenetURI.getGuessableKey());
        }
        if (freenetURI.getKeyType().equals("SVK")) {
            return new ClientSVK(Core.randSource);
        }
        if (freenetURI.getKeyType().equals("SSK")) {
            return new ClientSSK((Random)Core.randSource, freenetURI);
        }
        throw new KeyException("Unsupported keytype in URI");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

