/*
 * Decompiled with CFR 0.152.
 */
package Freenet.contrib.fproxy;

import Freenet.BadAddressException;
import Freenet.Conduit;
import Freenet.Params;
import Freenet.client.Base64;
import Freenet.client.ClientSVK;
import Freenet.client.FreenetURI;
import Freenet.client.SimplifiedClient;
import Freenet.contrib.fproxy.FProxyDocument;
import Freenet.contrib.fproxy.NoDataException;
import Freenet.contrib.fproxy.ProxyClient;
import Freenet.contrib.fproxy.ProxyServer;
import Freenet.contrib.fproxy.mumail.mime.MIME;
import Freenet.contrib.fproxy.mumail.mime.MIME_application;
import Freenet.contrib.fproxy.mumail.mime.MIME_multipart;
import Freenet.contrib.fproxy.mumail.mime.MIMEbinary;
import Freenet.contrib.fproxy.mumail.mime.MIMEcoder;
import Freenet.contrib.fproxy.mumail.mime.MIMEtext;
import Freenet.contrib.fproxy.mumail.mime.mimeMail;
import Freenet.keys.SVK;
import Freenet.servlet.GenericServlet;
import Freenet.servlet.ServletException;
import Freenet.servlet.ServletRequest;
import Freenet.servlet.ServletResponse;
import Freenet.servlet.util.FreenetServletRequest;
import Freenet.servlet.util.FreenetServletResponse;
import Freenet.support.HtmlLogger;
import Freenet.support.Logger;
import Freenet.support.StringUtils;
import Freenet.support.URLDecoder;
import Freenet.support.URLEncodedFormatException;
import Freenet.support.io.UnbufferedReader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.StringTokenizer;

public class HttpHandlerServlet
extends GenericServlet {
    private static final char[] lf = new char[]{'\n'};
    private static final long dataStreamTimeout = 10000000L;
    private InputStream in;
    private OutputStream out;
    private PrintWriter pw;
    private Logger saveLogger;
    private String typeExpected = "";
    private Params params;
    static /* synthetic */ Class class$Freenet$contrib$fproxy$HttpHandlerServlet;

    public HttpHandlerServlet() {
        this(new Params());
    }

    public HttpHandlerServlet(Params params) {
        if (ProxyServer.sc == null) {
            ProxyServer.sc = new SimplifiedClient(params);
        }
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException {
        FreenetServletResponse freenetServletResponse;
        FreenetServletRequest freenetServletRequest;
        try {
            freenetServletRequest = (FreenetServletRequest)servletRequest;
            freenetServletResponse = (FreenetServletResponse)servletResponse;
        }
        catch (ClassCastException classCastException) {
            throw new ServletException("HttpHandlerServlet needs FreenetServletRequest and FreenetServletResponse so that it can access raw InputStream and OutputStream objects.");
        }
        this.in = new BufferedInputStream(freenetServletRequest.getNormalInputStream());
        this.out = freenetServletResponse.getNormalOutputStream();
        this.pw = new PrintWriter(this.out);
        ProxyServer.sc.getLogger().log(this, "New HttpHandler", Logger.MINOR);
        this.run();
    }

    public void run() {
        try {
            UnbufferedReader unbufferedReader = new UnbufferedReader(this.in);
            String string = unbufferedReader.readLine();
            ProxyServer.sc.getLogger().log(this, string, Logger.MINOR);
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("GET")) {
                this.get(string3);
            } else if (string2.equalsIgnoreCase("POST")) {
                this.post(this.in);
            } else {
                this.unimplemented(string2);
            }
        }
        catch (EOFException eOFException) {
            ProxyServer.sc.getLogger().log(this, "Encountered EOFException", Logger.ERROR);
            eOFException.printStackTrace(ProxyServer.sc.getLogger().getOut());
        }
        catch (IOException iOException) {
            ProxyServer.sc.getLogger().log(this, "Encountered IOException", Logger.ERROR);
            iOException.printStackTrace(ProxyServer.sc.getLogger().getOut());
        }
        catch (RuntimeException runtimeException) {
            ProxyServer.sc.getLogger().log(this, "Encountered runtime exception", Logger.ERROR);
            runtimeException.printStackTrace(ProxyServer.sc.getLogger().getOut());
        }
    }

    protected void get(String string) throws IOException {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        FProxyDocument fProxyDocument = null;
        try {
            block22: {
                try {
                    if (string.equals("")) {
                        System.out.println("No key, loading gateway.html.");
                        this.pw.print("HTTP/1.0 200 OK\r\n");
                        this.pw.print("Connection: close\r\n");
                        this.pw.println("Content-type: text/html");
                        this.pw.println();
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((class$Freenet$contrib$fproxy$HttpHandlerServlet == null ? (class$Freenet$contrib$fproxy$HttpHandlerServlet = HttpHandlerServlet.class$("Freenet.contrib.fproxy.HttpHandlerServlet")) : class$Freenet$contrib$fproxy$HttpHandlerServlet).getResourceAsStream("gateway.html")));
                        String string2 = bufferedReader.readLine();
                        while (string2 != null) {
                            this.pw.println(string2);
                            string2 = bufferedReader.readLine();
                        }
                        this.pw.flush();
                        this.out.flush();
                        this.out.close();
                        break block22;
                    }
                    if (string.startsWith("?") && string.indexOf(61) > 0) {
                        string = string.substring(string.indexOf(61) + 1);
                        string = URLDecoder.decode(string);
                    }
                    this.pw.flush();
                    ProxyClient proxyClient = new ProxyClient(this.out, ProxyServer.sc);
                    fProxyDocument = proxyClient.request(string);
                    if (fProxyDocument.in == null) {
                        throw new FileNotFoundException();
                    }
                    if (fProxyDocument.mimeType == null) {
                        fProxyDocument.mimeType = this.guessMimeType(string);
                    }
                    this.pw.print("HTTP/1.0 200 OK\r\n");
                    this.pw.print("Connection: close\r\n");
                    if (fProxyDocument.mimeType != null) {
                        this.pw.println("Content-type: " + fProxyDocument.mimeType);
                    }
                    if (fProxyDocument.mimeType.equals("application/unknown")) {
                        this.pw.println("Content-Disposition: attachment; filename=" + string);
                    }
                    this.pw.println();
                    this.pw.flush();
                    Conduit conduit = new Conduit(fProxyDocument.in, this.out, null);
                    conduit.run();
                    this.out.flush();
                    this.out.close();
                }
                catch (Exception exception) {
                    this.pw.print("HTTP/1.0 404 Not Found\r\n");
                    this.pw.print("Connection: close\r\n");
                    this.pw.println("Content-type: text/html");
                    this.pw.println("");
                    this.pw.println("<html>");
                    this.pw.println("<head>");
                    this.pw.println("<title> Couldn't retrieve " + string + "</title>");
                    this.pw.println("</head>");
                    this.pw.println("");
                    this.pw.println("<body>");
                    this.pw.println("<p>Couldn't retrieve key: <b>" + string + "</b><br>");
                    this.sendHTMLFooter();
                    if (exception instanceof FileNotFoundException) {
                        ProxyServer.sc.getLogger().log(this, "File not found in Freenet", Logger.DEBUGGING);
                    } else if (exception instanceof NoDataException) {
                        ProxyServer.sc.getLogger().log(this, "File not found in Freenet", Logger.DEBUGGING);
                    } else if (exception instanceof URLEncodedFormatException) {
                        ProxyServer.sc.getLogger().log(this, "Invalid urlencoded key: " + string, Logger.ERROR);
                    } else if (exception instanceof MalformedURLException) {
                        ProxyServer.sc.getLogger().log(this, "Invalid Freenet URI: " + string, Logger.ERROR);
                    } else if (exception instanceof BadAddressException) {
                        ProxyServer.sc.getLogger().log(this, "Invalid Freenet server address: " + ProxyServer.serverAddress, Logger.ERROR);
                    } else {
                        ProxyServer.sc.getLogger().log(this, "Client object signalled: " + exception, Logger.ERROR);
                        exception.printStackTrace();
                    }
                    Object var6_9 = null;
                    ProxyServer.sc.getLogger().log(this, "Finished handling request, user's turn now", Logger.MINOR);
                }
            }
            Object var6_8 = null;
            ProxyServer.sc.getLogger().log(this, "Finished handling request, user's turn now", Logger.MINOR);
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            ProxyServer.sc.getLogger().log(this, "Finished handling request, user's turn now", Logger.MINOR);
            throw throwable;
        }
    }

    private String guessMimeType(String string) {
        if (string.toLowerCase().indexOf("html") != -1) {
            return "text/html";
        }
        if (string.toLowerCase().indexOf("text") != -1) {
            return "text/plain";
        }
        if (string.toLowerCase().indexOf("txt") != -1) {
            return "text/plain";
        }
        if (string.toLowerCase().indexOf("gif") != -1) {
            return "image/gif";
        }
        if (string.toLowerCase().indexOf("jpeg") != -1) {
            return "image/jpeg";
        }
        if (string.toLowerCase().indexOf("jpg") != -1) {
            return "image/jpeg";
        }
        if (string.toLowerCase().indexOf("mp3") != -1) {
            return "audio/mpeg3";
        }
        if (string.toLowerCase().indexOf("mpeg") != -1) {
            return "video/mpeg";
        }
        if (string.toLowerCase().indexOf("mpg") != -1) {
            return "video/mpeg";
        }
        return "application/unknown";
    }

    protected void post(InputStream inputStream) throws IOException {
        this.pw.print("HTTP/1.0 200 OK\r\n");
        this.pw.print("Connection: close\r\n");
        this.logOut();
        this.pw.println("Content-type: text/html\n");
        this.pw.println("<html><head><title>Freenet insert</title></head><body>");
        this.pw.flush();
        mimeMail mimeMail2 = new mimeMail(inputStream, this.pw);
        String string = "<no key specified>";
        String string2 = "application/octet-stream";
        try {
            Object object;
            this.typeExpected = "multipart/form-data";
            MIME_multipart mIME_multipart = (MIME_multipart)mimeMail2.getBody();
            ProxyServer.sc.getLogger().log(this, "Content-type: " + mimeMail2.getHeader().getContent_Type() + " (" + mIME_multipart.getPartCount() + " parts)", Logger.DEBUGGING);
            int n = 0;
            while (n < mIME_multipart.getPartCount()) {
                ProxyServer.sc.getLogger().log(this, n + " content-type: " + mIME_multipart.getPart(n).getHeader().getContent_Type(), Logger.DEBUGGING);
                ++n;
            }
            if (mIME_multipart.getPartCount() < 3) {
                throw new RuntimeException("Form data must contain at least three parts");
            }
            MIME mIME = mIME_multipart.getPart(0);
            MIME mIME2 = mIME_multipart.getPart(1);
            MIME mIME3 = mIME_multipart.getPart(2);
            this.typeExpected = "application/octet-stream";
            string = new String(((MIME_application)mIME).getBody());
            string2 = new String(((MIME_application)mIME3).getBody());
            ProxyServer.sc.getLogger().log(this, "User specified content-type: " + string2, Logger.DEBUGGING);
            byte[] byArray = new byte[]{};
            if (mIME2 instanceof MIMEtext) {
                object = (MIMEtext)mIME2;
                byArray = MIMEcoder.decode7Bit(((MIMEtext)object).getLines(), 0, ((MIMEtext)object).getLines().length);
            } else if (mIME2 instanceof MIMEbinary) {
                object = (MIMEbinary)mIME2;
                byArray = ((MIMEbinary)object).getBody();
            }
            if ((string2 == null || string2.equalsIgnoreCase("auto")) && (string2 = mIME2.getHeader().getContent_Type()).equalsIgnoreCase("application/unspecified")) {
                string2 = null;
            }
            ProxyServer.sc.getLogger().log(this, "Inserting with content-type: " + string2, Logger.DEBUGGING);
            if (byArray.length == 0) {
                this.pw.println("Inserting key: <b>" + string + "</b>");
                this.pw.println("<p>You didn't send any data!</p>");
                this.pw.flush();
                return;
            }
            this.pw.println("<p>Inserting key: <b>" + string + "</b></p>");
            this.pw.println("<p>");
            this.pw.flush();
            object = new ByteArrayInputStream(byArray);
            ProxyClient proxyClient = new ProxyClient(this.out, ProxyServer.sc);
            string = proxyClient.insert(string, (InputStream)object, string2);
            this.pw.println("</p>");
            this.pw.println("<p>The insert completed successfully.<br>");
            this.pw.println("To retrieve this file in the future, use this URI: <b>" + string + "</b></p");
            String string3 = (String)StringUtils.split(string, ':').elementAt(1);
            String string4 = (String)StringUtils.split(string3, '@').elementAt(0);
            if (string4.equals("SVK")) {
                ClientSVK clientSVK = new ClientSVK(new FreenetURI(string3));
                this.pw.println("<p>The SVK private key used was: <code>" + Base64.encode(((SVK)clientSVK.getKey()).getKeyPair().getX().toByteArray()) + "</code>.<br>");
                this.pw.println("Hang on to this key if you wish to update it in the future, or if you wish to insert subspace keys (SSKs) under this SVK root.</p>");
            }
            this.pw.flush();
            boolean bl = true;
            int n2 = 3;
            while (n2 < mIME_multipart.getPartCount()) {
                MIME mIME4 = mIME_multipart.getPart(n2);
                String string5 = mIME4.getHeader().getContent_DispositionParameter("name");
                if (string5.equalsIgnoreCase("index")) {
                    this.typeExpected = "application/octet-stream";
                    String string6 = new String(((MIME_application)mIME4).getBody());
                    if (bl) {
                        this.pw.println("<hr>Submitting key to indexes: <b>" + string + "</b>");
                        this.pw.println("<p>The keyindex server is only a temporary tool for alpha testers. It is not a permanent feature of the system. It will be removed in a future release.</p>");
                        this.pw.println("<p>");
                        this.pw.flush();
                        bl = false;
                    }
                    this.pw.println("Notifying " + string6 + "... ");
                    this.pw.flush();
                    try {
                        URL uRL = new URL(string6 + "?key=" + URLEncoder.encode(string));
                        InputStream inputStream2 = uRL.openStream();
                        inputStream2.read();
                        inputStream2.close();
                        this.pw.println("ok.<br>");
                        this.pw.flush();
                    }
                    catch (Exception exception) {
                        ProxyServer.sc.getLogger().log(this, "Inform connection to " + string6 + " failed: " + exception, Logger.ERROR);
                    }
                }
                ++n2;
            }
            if (!bl) {
                this.pw.println("<p>done.</p>");
                this.pw.flush();
            }
            this.sendHTMLFooter();
            this.logIn();
            ProxyServer.sc.getLogger().log(this, "Finished handling insert", Logger.MINOR);
        }
        catch (Exception exception) {
            this.pw.println("</p>");
            this.pw.println("<p>Couldn't insert key: <b>" + string + "</b><br>");
            if (exception instanceof ClassCastException) {
                throw new RuntimeException("Unexpected form data type: " + mimeMail2.getHeader().getContent_Type() + " (expecting " + this.typeExpected + ")");
            }
            if (exception instanceof MalformedURLException) {
                ProxyServer.sc.getLogger().log(this, "Invalid Freenet URI: " + string, Logger.ERROR);
            }
            if (exception instanceof BadAddressException) {
                ProxyServer.sc.getLogger().log(this, "Invalid Freenet server address: " + ProxyServer.serverAddress, Logger.ERROR);
            }
            ProxyServer.sc.getLogger().log(this, "Client object signalled: " + exception, Logger.ERROR);
            exception.printStackTrace();
        }
    }

    protected void unimplemented(String string) throws IOException {
        ProxyServer.sc.getLogger().log(this, "Sending HTTP 501 response", Logger.MINOR);
        this.pw.print("HTTP/1.0 501 Not Implemented\r\n\r\n");
        this.pw.println("<HTML><HEAD>");
        this.pw.println("<TITLE>501 Not Implemented</TITLE>");
        this.pw.println("</HEAD><BODY>");
        this.pw.println("<H1>" + string + " Method Not Implemented</H1>");
        this.pw.println("</BODY></HTML>");
        this.pw.flush();
        throw new RuntimeException(string + " method not implemented");
    }

    private void sendHTMLFooter() throws IOException {
        this.pw.println("</body>");
        this.pw.println("</html>");
        this.pw.flush();
    }

    private void logOut() throws IOException {
        ProxyServer.sc.getLogger().log(this, "Transferring log messages to HTTP stream", Logger.MINOR);
        this.saveLogger = ProxyServer.sc.getLogger();
        ProxyServer.sc.setLogger(new HtmlLogger(this.out, 0, this.saveLogger.threshold));
    }

    private void logIn() {
        ProxyServer.sc.setLogger(this.saveLogger);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

