/*
 * Decompiled with CFR 0.152.
 */
package Freenet.contrib.fproxy;

import Freenet.ListenException;
import Freenet.ListeningAddress;
import Freenet.Params;
import Freenet.client.ServletConstructor;
import Freenet.client.ServletHandler;
import Freenet.client.SimplifiedClient;
import Freenet.support.Logger;
import Freenet.support.StandardLogger;
import Freenet.support.SuppressedLogger;
import java.io.IOException;

public class ProxyServer {
    private static final int defaultListenPort = 8080;
    private static final String defaultServerAddress = "tcp/localhost:19114";
    private static final long defaultHopsToLive = 5L;
    private static final String defaultLogFile = "fproxy.log";
    private static final String defaultLogging = "normal";
    private static final int defaultVerbosity = 1;
    public static int listenPort;
    public static String serverAddress;
    public static long hopsToLive;
    public static SimplifiedClient sc;

    public static void main(String[] stringArray) {
        Params params = new Params(stringArray);
        if (params.getParam("help") != null) {
            ProxyServer.usage();
            return;
        }
        sc = new SimplifiedClient(params);
        listenPort = params.getint("listenPort", 8080);
        serverAddress = params.getParam("serverAddress", defaultServerAddress);
        hopsToLive = params.getlong("htl", 5L);
        int n = StandardLogger.priorityOf(params.getParam("logging", defaultLogging));
        int n2 = params.getint("verbosity", 1);
        String string = params.getParam("logFile", defaultLogFile);
        try {
            if (!string.equalsIgnoreCase("NO")) {
                sc.setLogger(new StandardLogger(string, n2, n));
            } else {
                sc.setLogger(new StandardLogger(System.err, n2, n));
            }
        }
        catch (IOException iOException) {
            System.err.println("Writing to log failed!");
            sc.setLogger(new SuppressedLogger());
        }
        try {
            ServletConstructor servletConstructor = new ServletConstructor("Freenet.contrib.fproxy.HttpHandlerServlet", params);
            ServletHandler servletHandler = new ServletHandler(new ListeningAddress("tcp/" + listenPort), servletConstructor);
            servletHandler.acceptConnections();
        }
        catch (ListenException listenException) {
            sc.getLogger().log(null, "Could not listen on port " + listenPort, Logger.ERROR);
            System.exit(1);
        }
    }

    public static void usage() {
        System.out.println("fproxy version 0.3");
        System.out.println("Usage: fproxy [options]");
        System.out.println("");
        System.out.println("  -listenPort port           Local port to listen on");
        System.out.println("  -serverAddress address     Server node to connect to");
        System.out.println("  -htl hops-to-live          Hops-to-live for request");
        System.out.println("  -logFile file              Name of log file (`no' to log to console)");
        System.out.println("  -logging error|normal|minor|debugging");
        System.out.println("                             Logging level");
        System.out.println("  -verbosity 0-5             Verbosity of log messages");
        System.out.println("  -help                      Display this help and exit");
        System.out.println("");
        System.out.println("Send bug reports to Theodore Hong <twh1@doc.ic.ac.uk>.");
    }

    static {
        serverAddress = defaultServerAddress;
    }
}

