/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.crypt.SHA1;
import Freenet.crypt.Util;
import Freenet.support.Fields;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Hashtable;

public abstract class CryptoKey {
    protected static Hashtable keytypes = new Hashtable();
    protected static final SHA1 shactx = new SHA1();
    protected final CryptoKey dependent;
    static /* synthetic */ Class class$java$io$DataInputStream;
    static /* synthetic */ Class class$Freenet$crypt$CryptoKey;

    CryptoKey() {
        this.dependent = null;
    }

    CryptoKey(CryptoKey cryptoKey) {
        this.dependent = cryptoKey;
    }

    static CryptoKey read(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        String string = dataInputStream.readUTF();
        boolean bl = dataInputStream.readBoolean();
        CryptoKey cryptoKey = null;
        if (bl) {
            cryptoKey = CryptoKey.read(inputStream);
        }
        try {
            Object[] objectArray;
            Class<?> clazz = Class.forName(string);
            Method method = bl ? clazz.getMethod("read", class$java$io$DataInputStream == null ? (class$java$io$DataInputStream = CryptoKey.class$("java.io.DataInputStream")) : class$java$io$DataInputStream, class$Freenet$crypt$CryptoKey == null ? (class$Freenet$crypt$CryptoKey = CryptoKey.class$("Freenet.crypt.CryptoKey")) : class$Freenet$crypt$CryptoKey) : clazz.getMethod("read", class$java$io$DataInputStream == null ? (class$java$io$DataInputStream = CryptoKey.class$("java.io.DataInputStream")) : class$java$io$DataInputStream);
            CryptoKey cryptoKey2 = null;
            if (bl) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = dataInputStream;
                objectArray = objectArray2;
                objectArray2[1] = cryptoKey;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = dataInputStream;
            }
            cryptoKey2 = (CryptoKey)method.invoke(null, objectArray);
            return cryptoKey2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            return null;
        }
    }

    abstract void write(OutputStream var1) throws IOException;

    void write(DataOutputStream dataOutputStream, String string) throws IOException {
        dataOutputStream.writeUTF(string);
        dataOutputStream.writeBoolean(this.dependent != null);
        if (this.dependent != null) {
            this.dependent.write(dataOutputStream);
        }
    }

    public abstract String keyType();

    public abstract byte[] fingerprint();

    protected byte[] fingerprint(BigInteger[] bigIntegerArray) {
        SHA1 sHA1 = shactx;
        synchronized (sHA1) {
            byte[] byArray;
            int n = 0;
            while (n < bigIntegerArray.length) {
                byArray = Util.MPIbytes(bigIntegerArray[n]);
                shactx.update(byArray, 0, byArray.length);
                ++n;
            }
            byArray = shactx.digest();
            return byArray;
        }
    }

    public String verboseToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toString()).append('\t').append(this.fingerprintToString());
        if (this.dependent != null) {
            stringBuffer.append("\n \\_").append(this.dependent.verboseToString());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.keyType()).append('/');
        stringBuffer.append(Fields.bytesToHex(this.fingerprint(), 16, 4));
        return stringBuffer.toString();
    }

    public String fingerprintToString() {
        byte[] byArray = this.fingerprint();
        String string = Fields.bytesToHex(byArray, 0, byArray.length);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, 4)).append(' ');
        stringBuffer.append(string.substring(4, 8)).append(' ');
        stringBuffer.append(string.substring(8, 12)).append(' ');
        stringBuffer.append(string.substring(12, 16)).append(' ');
        stringBuffer.append(string.substring(16, 20)).append("  ");
        stringBuffer.append(string.substring(20, 24)).append(' ');
        stringBuffer.append(string.substring(24, 28)).append(' ');
        stringBuffer.append(string.substring(28, 32)).append(' ');
        stringBuffer.append(string.substring(32, 36)).append(' ');
        stringBuffer.append(string.substring(36, 40));
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        CryptoKey cryptoKey = CryptoKey.read(new FileInputStream(stringArray[0]));
        System.out.println(cryptoKey.verboseToString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

