/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.crypt.CryptoKey;
import Freenet.crypt.DSAKeyPair;
import Freenet.crypt.DSASignature;
import Freenet.crypt.SHA1;
import Freenet.crypt.Util;
import Freenet.crypt.Yarrow;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.util.Random;

public class DSA {
    public static DSASignature sign(DSAKeyPair dSAKeyPair, BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = dSAKeyPair.getG().modPow(bigInteger, dSAKeyPair.getP()).mod(dSAKeyPair.getQ());
        BigInteger bigInteger4 = bigInteger.modInverse(dSAKeyPair.getQ());
        return DSA.sign(dSAKeyPair, bigInteger3, bigInteger4, bigInteger2);
    }

    public static BigInteger[][] signaturePrecalculate(DSAKeyPair dSAKeyPair, int n, Random random) {
        BigInteger[][] bigIntegerArray = new BigInteger[n][2];
        int n2 = 0;
        while (n2 < n) {
            BigInteger bigInteger;
            while ((bigInteger = Util.generateLargeRandom(80, 160, random)).compareTo(dSAKeyPair.getQ()) > -1 || bigInteger.compareTo(Util.ZERO) == 0) {
            }
            bigIntegerArray[n2][0] = dSAKeyPair.getG().modPow(bigInteger, dSAKeyPair.getP());
            bigIntegerArray[n2][1] = bigInteger.modInverse(dSAKeyPair.getQ());
            ++n2;
        }
        return bigIntegerArray;
    }

    public static DSASignature sign(DSAKeyPair dSAKeyPair, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = bigInteger3.add(dSAKeyPair.getX().multiply(bigInteger)).mod(dSAKeyPair.getQ());
        BigInteger bigInteger5 = bigInteger2.multiply(bigInteger4).mod(dSAKeyPair.getQ());
        return new DSASignature(bigInteger, bigInteger5);
    }

    public static boolean verify(DSAKeyPair dSAKeyPair, DSASignature dSASignature, BigInteger bigInteger) {
        BigInteger bigInteger2 = dSASignature.getS().modInverse(dSAKeyPair.getQ());
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2).mod(dSAKeyPair.getQ());
        BigInteger bigInteger4 = dSASignature.getR().multiply(bigInteger2).mod(dSAKeyPair.getQ());
        BigInteger bigInteger5 = dSAKeyPair.getG().modPow(bigInteger3, dSAKeyPair.getP());
        BigInteger bigInteger6 = dSAKeyPair.getY().modPow(bigInteger4, dSAKeyPair.getP());
        BigInteger bigInteger7 = bigInteger5.multiply(bigInteger6).mod(dSAKeyPair.getP()).mod(dSAKeyPair.getQ());
        return bigInteger7.equals(dSASignature.getR());
    }

    public static void main(String[] stringArray) throws Exception {
        Yarrow yarrow = new Yarrow();
        SHA1 sHA1 = new SHA1();
        File file = new File(stringArray[1]);
        File file2 = new File(stringArray[2]);
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        DSAKeyPair dSAKeyPair = (DSAKeyPair)CryptoKey.read(fileInputStream);
        byte[] byArray = Util.hashFile(sHA1, file);
        BigInteger bigInteger = Util.byteArrayToMPI(byArray);
        if (stringArray.length == 4 && stringArray[3].equals("sign")) {
            BigInteger bigInteger2 = new BigInteger(159, yarrow);
            BigInteger[][] bigIntegerArray = DSA.signaturePrecalculate(dSAKeyPair, 2000, yarrow);
            DSASignature dSASignature = null;
            long l = System.currentTimeMillis();
            int n = 0;
            while (n < 2000) {
                dSASignature = DSA.sign(dSAKeyPair, bigIntegerArray[n][0], bigIntegerArray[n][1], bigInteger);
                ++n;
            }
            System.out.println("Time:" + (System.currentTimeMillis() - l));
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            dSASignature.write(fileOutputStream);
            fileOutputStream.close();
        } else {
            FileInputStream fileInputStream2 = new FileInputStream(file2);
            DSASignature dSASignature = new DSASignature(fileInputStream2);
            long l = System.currentTimeMillis();
            int n = 0;
            while (n < 1000) {
                DSA.verify(dSAKeyPair, dSASignature, bigInteger);
                ++n;
            }
            System.out.println("Time:" + (System.currentTimeMillis() - l));
            System.err.println(DSA.verify(dSAKeyPair, dSASignature, bigInteger));
        }
    }
}

