/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.crypt.KeyPair;
import Freenet.crypt.SHA1;
import Freenet.crypt.Util;
import Freenet.crypt.Yarrow;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Random;
import java.util.StringTokenizer;

public class DSAGroup
extends KeyPair {
    public DSAGroup(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        super(null, new BigInteger[]{bigInteger, bigInteger2, bigInteger3});
    }

    public static DSAGroup parse(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        BigInteger bigInteger = Util.byteArrayToMPI(Util.hexToBytes(stringTokenizer.nextToken()));
        BigInteger bigInteger2 = Util.byteArrayToMPI(Util.hexToBytes(stringTokenizer.nextToken()));
        BigInteger bigInteger3 = Util.byteArrayToMPI(Util.hexToBytes(stringTokenizer.nextToken()));
        return new DSAGroup(bigInteger, bigInteger2, bigInteger3);
    }

    public static KeyPair read(DataInputStream dataInputStream) throws IOException {
        BigInteger[][] bigIntegerArray = KeyPair.readKeys(dataInputStream);
        return new DSAGroup(bigIntegerArray[1][0], bigIntegerArray[1][1], bigIntegerArray[1][2]);
    }

    public void write(OutputStream outputStream) throws IOException {
        super.write(new DataOutputStream(outputStream), this.getClass().getName());
    }

    public String keyType() {
        return "DSAg-" + this.y[0].bitLength();
    }

    public BigInteger getP() {
        return this.y[0];
    }

    public BigInteger getQ() {
        return this.y[1];
    }

    public BigInteger getG() {
        return this.y[2];
    }

    public static DSAGroup generate(int n, Random random) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        SHA1 sHA1 = new SHA1();
        BigInteger bigInteger5 = Util.TWO.pow(1023);
        int n2 = (n - 1) / 160;
        int n3 = n - 1 - 160 * n2;
        int n4 = 0;
        int n5 = 0;
        do {
            if (n4++ % 10 == 0) {
                System.err.print(".");
            }
            bigInteger2 = new BigInteger(n >> 2, random);
            int n6 = bigInteger2.bitLength();
            bigInteger = Util.TWO.pow(n6);
        } while ((bigInteger4 = (bigInteger3 = new BigInteger(DSAGroup.xor(DSAGroup.hash(sHA1, Util.MPIbytes(bigInteger2)), DSAGroup.hash(sHA1, Util.MPIbytes(bigInteger2.add(Util.ONE).mod(bigInteger)))))).setBit(bigInteger3.bitLength()).setBit(0)).bitLength() != 160 || !bigInteger4.isProbablePrime(80));
        BigInteger bigInteger6 = Util.ZERO;
        bigInteger3 = Util.TWO;
        BigInteger[] bigIntegerArray = new BigInteger[n2];
        while (true) {
            BigInteger bigInteger7;
            int n7 = 0;
            while (n7 < n2) {
                bigIntegerArray[n7] = new BigInteger(DSAGroup.hash(sHA1, Util.MPIbytes(bigInteger2.add(bigInteger3).add(BigInteger.valueOf(n7)).mod(bigInteger))));
                ++n7;
            }
            BigInteger bigInteger8 = bigIntegerArray[0];
            int n8 = 1;
            while (n8 < n2 - 1) {
                bigInteger8 = bigInteger8.add(Util.TWO.pow(160 * n8).multiply(bigIntegerArray[n8]));
                ++n8;
            }
            BigInteger bigInteger9 = (bigInteger8 = bigInteger8.add(Util.TWO.pow(160 * n2).multiply(bigIntegerArray[n2 - 1].mod(Util.TWO.pow(n3))))).add(bigInteger5);
            BigInteger bigInteger10 = bigInteger9.subtract(bigInteger7 = bigInteger9.mod(Util.TWO.multiply(bigInteger4)).subtract(Util.ONE));
            if (bigInteger10.compareTo(bigInteger5) == -1) continue;
            if (n5++ % 20 == 0) {
                System.err.print("+");
            }
            if (bigInteger10.isProbablePrime(80)) {
                BigInteger bigInteger11;
                BigInteger bigInteger12;
                System.err.println("S=0x" + bigInteger2.toString(16));
                System.err.println("C=" + bigInteger6);
                System.err.println("N=" + bigInteger3);
                BigInteger bigInteger13 = bigInteger10.subtract(Util.ONE);
                do {
                    bigInteger12 = new BigInteger(512, random);
                    bigInteger11 = bigInteger12.modPow(bigInteger13.divide(bigInteger4), bigInteger10);
                } while (bigInteger12.compareTo(bigInteger10.subtract(Util.ONE)) != -1 && bigInteger11.compareTo(Util.ONE) < 1);
                return new DSAGroup(bigInteger10, bigInteger4, bigInteger11);
            }
            bigInteger6 = bigInteger6.add(Util.ONE);
            bigInteger3 = bigInteger3.add(bigInteger3).add(BigInteger.valueOf(n2)).add(Util.ONE);
            if (bigInteger6.compareTo(BigInteger.valueOf(4096L)) == 0) break;
        }
        return DSAGroup.generate(n, random);
    }

    public static byte[] xor(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + 1];
        int n = 0;
        while (n < byArray.length) {
            byArray3[n + 1] = (byte)(byArray[n] ^ byArray2[n]);
            ++n;
        }
        return byArray3;
    }

    public static byte[] hash(SHA1 sHA1, byte[] byArray) {
        sHA1.update(byArray, 0, byArray.length);
        byte[] byArray2 = sHA1.digest();
        return byArray2;
    }

    public static void main(String[] stringArray) {
        DSAGroup.generate(Integer.parseInt(stringArray[0]), new Yarrow("/dev/random", "SHA1", "Rijndael"));
    }
}

