/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.crypt.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class DSASignature {
    private final BigInteger r;
    private final BigInteger s;

    public DSASignature(InputStream inputStream) throws IOException {
        this.r = Util.readMPI(inputStream);
        this.s = Util.readMPI(inputStream);
    }

    public DSASignature(String string) {
        int n = string.indexOf(44);
        this.r = Util.byteArrayToMPI(Util.hexToBytes(string.substring(0, n)));
        this.s = Util.byteArrayToMPI(Util.hexToBytes(string.substring(n + 1)));
    }

    public void write(OutputStream outputStream) throws IOException {
        Util.writeMPI(this.r, outputStream);
        Util.writeMPI(this.s, outputStream);
    }

    public DSASignature(BigInteger bigInteger, BigInteger bigInteger2) {
        this.r = bigInteger;
        this.s = bigInteger2;
    }

    public BigInteger getR() {
        return this.r;
    }

    public BigInteger getS() {
        return this.s;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.r.toString(16).toUpperCase()).append(',');
        stringBuffer.append(this.s.toString(16).toUpperCase());
        return stringBuffer.toString();
    }
}

