/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.crypt.BlockCipher;
import Freenet.crypt.RandomSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PCFBMode {
    private BlockCipher c;
    private byte[] feedback_register;
    private byte[] buffer;
    protected int registerPointer;
    protected int blockSizeBytes;

    public PCFBMode(BlockCipher blockCipher) {
        this.c = blockCipher;
        this.blockSizeBytes = blockCipher.getBlockSize() >> 3;
        this.feedback_register = new byte[this.blockSizeBytes];
        this.buffer = new byte[this.feedback_register.length];
        this.registerPointer = this.feedback_register.length;
    }

    void writeIV(RandomSource randomSource, OutputStream outputStream) throws IOException {
        randomSource.nextBytes(this.feedback_register);
        outputStream.write(this.feedback_register);
    }

    void readIV(InputStream inputStream) throws IOException {
        int n = 0;
        while (n < this.feedback_register.length) {
            this.feedback_register[n] = (byte)inputStream.read();
            ++n;
        }
    }

    public void acceptIV(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            this.feedback_register[n] = byArray[n];
            ++n;
        }
    }

    synchronized int decipher(int n) {
        if (this.registerPointer < this.feedback_register.length) {
            int n2 = (this.feedback_register[this.registerPointer] ^ (byte)n) & 0xFF;
            this.feedback_register[this.registerPointer++] = (byte)n;
            return n2;
        }
        this.refillBuffer();
        return this.decipher(n);
    }

    synchronized int encipher(int n) {
        if (this.registerPointer < this.feedback_register.length) {
            this.feedback_register[this.registerPointer] = (byte)(this.feedback_register[this.registerPointer] ^ n);
            return this.feedback_register[this.registerPointer++] & 0xFF;
        }
        this.refillBuffer();
        return this.encipher(n);
    }

    synchronized byte[] blockEncipher(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < this.blockSizeBytes) {
            this.feedback_register[n2] = this.buffer[n2] = (byte)(byArray[n2 + n] ^ this.feedback_register[n2]);
            ++n2;
        }
        this.refillBuffer();
        return this.buffer;
    }

    protected synchronized void refillBuffer() {
        this.feedback_register = this.c.encipher(this.feedback_register);
        this.registerPointer = 0;
    }
}

