/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.crypt.Digest;
import Freenet.crypt.ProgressiveHashOutputStream;
import Freenet.crypt.SHA1;
import Freenet.crypt.SHA1Factory;
import Freenet.support.FileBucket;
import Freenet.support.io.DataNotValidIOException;
import Freenet.support.io.VerifyingInputStream;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressiveHashInputStream
extends VerifyingInputStream {
    private long partSize;
    private long read = 0L;
    private Digest dig;
    private byte[] expect;
    private byte[] buf;
    private byte[] res;
    private int pos = 0;
    private int endsWith = -1;
    private int dnvDiedCode = -1;

    public static void main(String[] stringArray) throws Exception {
        File file = new File(stringArray[0]);
        FileInputStream fileInputStream = new FileInputStream(file);
        long l = Long.parseLong(stringArray[1]);
        ProgressiveHashOutputStream progressiveHashOutputStream = new ProgressiveHashOutputStream(l, new SHA1Factory(), new FileBucket());
        int n = (int)file.length();
        int n2 = 0;
        byte[] byArray = new byte[1024];
        while (n > 0) {
            n2 = fileInputStream.read(byArray, 0, Math.min(n, byArray.length));
            progressiveHashOutputStream.write(byArray, 0, n2);
            n -= n2;
        }
        progressiveHashOutputStream.finish();
        byte[] byArray2 = progressiveHashOutputStream.getDigest();
        int n3 = 0;
        while (n3 < byArray2.length) {
            System.err.print((byArray2[n3++] & 0xFF) + " ");
        }
        long l2 = progressiveHashOutputStream.getLength();
        System.err.println("\nTotalLength = " + l2);
        InputStream inputStream = progressiveHashOutputStream.getData();
        ProgressiveHashInputStream progressiveHashInputStream = new ProgressiveHashInputStream(inputStream, l, l2, new SHA1(), byArray2);
        progressiveHashInputStream.stripControls(stringArray.length < 3 || Integer.parseInt(stringArray[2]) == 0);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(progressiveHashInputStream);
        int n4 = ((InputStream)bufferedInputStream).read(byArray);
        while (n4 > 0) {
            System.out.write(byArray, 0, n4);
            n4 = ((InputStream)bufferedInputStream).read(byArray);
        }
    }

    public ProgressiveHashInputStream(InputStream inputStream, long l, long l2, Digest digest, byte[] byArray) throws DataNotValidIOException {
        super(inputStream, l2);
        this.partSize = l;
        this.dig = digest;
        int n = digest.digestSize() >> 3;
        long l3 = l2 % (l + (long)n + 1L);
        if (l < 0L || l2 < 2L || l != 0L && (l > l2 - 23L || l3 > l + 1L || l3 < 2L)) {
            throw new DataNotValidIOException(0);
        }
        if (l == 0L) {
            this.partSize = 0x4000000000000000L;
        }
        this.expect = new byte[n];
        this.buf = new byte[n];
        this.res = new byte[n];
        System.arraycopy(byArray, 0, this.expect, 0, n);
    }

    public int read() throws DataNotValidIOException, IOException {
        if (this.dnvDiedCode != -1) {
            throw new DataNotValidIOException(this.dnvDiedCode);
        }
        int n = this.priv_read();
        if (this.stripControls && this.allRead) {
            this.priv_read();
        }
        return n;
    }

    private int priv_read() throws DataNotValidIOException, IOException {
        if (this.endsWith != -1) {
            this.valPart(this.endsWith);
            return this.endsWith;
        }
        if (this.finished) {
            return -1;
        }
        int n = super.read();
        if (n == -1) {
            throw new EOFException("Unexpected end of stream");
        }
        if (this.read < this.partSize) {
            ++this.read;
            if (!this.finished) {
                this.dig.update((byte)n);
            } else {
                this.valPart(n);
                if (this.stripControls) {
                    n = -1;
                }
            }
        } else {
            if (this.pos < this.buf.length) {
                if (this.finished) {
                    throw new EOFException("End of stream during control read");
                }
                this.buf[this.pos++] = (byte)n;
                this.dig.update((byte)n);
            } else {
                this.valPart(n);
            }
            if (this.stripControls) {
                n = this.priv_read();
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException, DataNotValidIOException {
        if (this.dnvDiedCode != -1) {
            throw new DataNotValidIOException(this.dnvDiedCode);
        }
        int n3 = this.priv_read(byArray, n, n2);
        if (this.stripControls && this.allRead) {
            this.priv_read();
        }
        return n3;
    }

    private int priv_read(byte[] byArray, int n, int n2) throws IOException, DataNotValidIOException {
        if (n2 == 0) {
            return 0;
        }
        if (this.endsWith != -1) {
            this.valPart(this.endsWith);
            byArray[n] = (byte)this.endsWith;
            return 1;
        }
        if (this.finished) {
            return -1;
        }
        if (this.read == this.partSize) {
            if (this.pos < this.buf.length) {
                int n3 = n2 < this.buf.length - this.pos ? n2 : this.buf.length - this.pos;
                int n4 = super.read(byArray, n, n3);
                if (n4 == -1) {
                    throw new EOFException("EOF while reading controls");
                }
                this.dig.update(byArray, n, n4);
                System.arraycopy(byArray, n, this.buf, this.pos, n4);
                this.pos += n4;
                if (this.stripControls) {
                    return this.priv_read(byArray, n, n2);
                }
                return n4;
            }
            int n5 = super.read();
            this.valPart(n5);
            if (this.stripControls) {
                return this.priv_read(byArray, n, n2);
            }
            byArray[n] = (byte)n5;
            return 1 + this.priv_read(byArray, n + 1, n2 - 1);
        }
        int n6 = this.read + (long)n2 > this.partSize ? (int)(this.partSize - this.read) : n2;
        int n7 = super.read(byArray, n, n6);
        if (n7 == -1) {
            throw new EOFException("Unexpected end of stream");
        }
        this.read += (long)n7;
        if (!this.finished) {
            this.dig.update(byArray, n, n7);
            return n7 + (n6 < n2 && this.read == this.partSize ? this.priv_read(byArray, n + n7, n2 - n6) : 0);
        }
        if (n7 == 1) {
            this.valPart(byArray[n + n7 - 1] & 0xFF);
            return !this.stripControls ? 1 : -1;
        }
        this.endsWith = byArray[n + n7 - 1] & 0xFF;
        return --n7;
    }

    private void valPart(int n) throws DataNotValidIOException {
        this.dig.digest(true, this.res, 0);
        if (!this.same(this.res, this.expect) || n != 0) {
            this.dnvDiedCode = n;
            throw new DataNotValidIOException(n);
        }
        System.arraycopy(this.buf, 0, this.expect, 0, this.buf.length);
        this.read = 0L;
        this.pos = 0;
    }

    private boolean same(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void finish() throws DataNotValidIOException, IOException {
        this.finished = true;
    }
}

