/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.crypt.Digest;
import Freenet.crypt.DigestFactory;
import Freenet.support.Bucket;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;

public class ProgressiveHashOutputStream
extends OutputStream {
    private Bucket b;
    private OutputStream out;
    private DigestFactory df;
    private Digest dig;
    private Stack digests;
    private long written;
    private long partSize;
    private long totalLength;
    private InputStream in;
    private byte[] value;
    private Stack dvals;

    public ProgressiveHashOutputStream(long l, DigestFactory digestFactory, Bucket bucket) throws IOException {
        this.b = bucket;
        bucket.resetWrite();
        this.out = new BufferedOutputStream(bucket.getOutputStream());
        this.df = digestFactory;
        this.dig = digestFactory.getInstance();
        this.partSize = l != 0L ? l : 0x4000000000000000L;
        this.digests = new Stack();
    }

    public void write(int n) throws IOException {
        this.priv_write(n);
    }

    private void priv_write(int n) throws IOException {
        if (this.written < this.partSize) {
            this.dig.update((byte)n);
            this.out.write(n);
            ++this.written;
        } else {
            this.digests.push(this.dig);
            this.dig = this.df.getInstance();
            this.written = 0L;
            this.priv_write(n);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.priv_write(byArray, n, n2);
    }

    private void priv_write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        if (this.written + (long)n2 <= this.partSize) {
            this.dig.update(byArray, n, n2);
            this.out.write(byArray, n, n2);
            this.written += (long)n2;
        } else if (this.written == this.partSize) {
            this.priv_write(byArray[n] & 0xFF);
            this.priv_write(byArray, n + 1, n2 - 1);
        } else {
            int n3 = (int)(this.partSize - this.written);
            this.priv_write(byArray, n, n3);
            this.priv_write(byArray, n + n3, n2 - n3);
        }
    }

    public synchronized void finish() throws IOException {
        this.close();
        this.dvals = new Stack();
        byte[] byArray = new byte[]{};
        while (!this.digests.empty()) {
            Digest digest = (Digest)this.digests.pop();
            digest.update(byArray, 0, byArray.length);
            byArray = digest.digest();
            this.dvals.push(byArray);
        }
        this.value = (byte[])this.dvals.pop();
        int n = (int)(this.b.size() / this.partSize);
        long l = this.b.size() % this.partSize;
        this.totalLength = (long)n * (this.partSize + 21L) + l + 1L;
    }

    public void close() throws IOException {
        this.digests.push(this.dig);
        this.out.close();
    }

    public synchronized byte[] getDigest() {
        return this.value;
    }

    public synchronized long getLength() {
        return this.totalLength;
    }

    public synchronized InputStream getData() throws IOException {
        return this.dvals == null ? null : new InterleaveInputStream(this.b);
    }

    protected class InterleaveInputStream
    extends FilterInputStream {
        private long read = 0L;
        private byte[] buf;
        private int pos = 0;
        private boolean ended;
        private int dSize;
        private int dig;

        public InterleaveInputStream(Bucket bucket) throws IOException {
            super(bucket.getInputStream());
            this.dig = ProgressiveHashOutputStream.this.dvals.size() - 1;
            this.buf = (byte[])(this.dig == -1 ? null : (byte[])ProgressiveHashOutputStream.this.dvals.elementAt(this.dig--));
            this.dSize = this.buf == null ? 0 : this.buf.length;
        }

        public int read() throws IOException {
            return this.priv_read();
        }

        private int priv_read() throws IOException {
            if (this.ended) {
                return -1;
            }
            if (this.read == ProgressiveHashOutputStream.this.partSize) {
                if (this.buf == null) {
                    this.ended = true;
                    return 0;
                }
                if (this.pos < this.buf.length) {
                    int n = this.buf[this.pos++] & 0xFF;
                    return n;
                }
                this.pos = 0;
                this.read = 0L;
                this.buf = (byte[])(this.dig >= 0 ? (byte[])ProgressiveHashOutputStream.this.dvals.elementAt(this.dig--) : null);
                return 0;
            }
            ++this.read;
            int n = super.read();
            if (n == -1) {
                this.ended = true;
                return 0;
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.priv_read(byArray, n, n2);
        }

        private int priv_read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 == 0) {
                return 0;
            }
            if (this.ended) {
                return -1;
            }
            if (this.read == ProgressiveHashOutputStream.this.partSize) {
                int n3;
                if (this.pos < this.buf.length) {
                    n3 = n2 < this.buf.length - this.pos ? n2 : this.buf.length - this.pos;
                    System.arraycopy(this.buf, this.pos, byArray, n, n3);
                    this.pos += n3;
                } else {
                    byArray[n] = (byte)this.priv_read();
                    n3 = 1;
                }
                return n3;
            }
            int n4 = (long)n2 < ProgressiveHashOutputStream.this.partSize - this.read ? n2 : (int)(ProgressiveHashOutputStream.this.partSize - this.read);
            if ((n4 = super.read(byArray, n, n4)) == -1) {
                byArray[n] = 0;
                ++this.read;
                this.ended = true;
                return 1;
            }
            this.read += (long)n4;
            return n4;
        }

        public int available() throws IOException {
            return this.ended ? 0 : super.available() + 1;
        }
    }
}

