/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.crypt.CryptoKey;
import Freenet.crypt.KeyPair;
import Freenet.crypt.RSA;
import Freenet.crypt.Util;
import Freenet.crypt.Yarrow;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Random;

public class RSAKeyPair
extends KeyPair {
    public static RSAKeyPair generate(int n, Random random, boolean bl) {
        BigInteger bigInteger = new BigInteger(n / 2, 12, random);
        BigInteger bigInteger2 = new BigInteger(n / 2, 12, random);
        RSAKeyPair rSAKeyPair = null;
        while (rSAKeyPair == null) {
            rSAKeyPair = RSAKeyPair.generate(new BigInteger(n / 2, 15, random), new BigInteger(n / 2, 15, random), bl);
        }
        return rSAKeyPair;
    }

    public static RSAKeyPair generate(BigInteger bigInteger, BigInteger bigInteger2, boolean bl) {
        BigInteger bigInteger3 = bigInteger.subtract(Util.ONE).multiply(bigInteger2.subtract(Util.ONE));
        BigInteger bigInteger4 = BigInteger.valueOf(65537L);
        if (Util.ONE.compareTo(bigInteger4.gcd(bigInteger3)) != 0) {
            return null;
        }
        BigInteger bigInteger5 = bigInteger.multiply(bigInteger2);
        BigInteger bigInteger6 = bigInteger4.modInverse(bigInteger3);
        return bl ? new RSAKeyPair(bigInteger6, bigInteger4, bigInteger5, bigInteger, bigInteger2) : new RSAKeyPair(bigInteger6, bigInteger4, bigInteger5);
    }

    public RSAKeyPair(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this(bigInteger, bigInteger2, bigInteger3, null, null);
    }

    public RSAKeyPair(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
        BigInteger[] bigIntegerArray;
        if (bigInteger4 != null) {
            BigInteger[] bigIntegerArray2 = new BigInteger[7];
            bigIntegerArray2[0] = bigInteger;
            bigIntegerArray2[1] = bigInteger4;
            bigIntegerArray2[2] = bigInteger5;
            bigIntegerArray2[3] = bigInteger.mod(bigInteger4.subtract(Util.ONE));
            bigIntegerArray2[4] = bigInteger.mod(bigInteger5.subtract(Util.ONE));
            bigIntegerArray2[5] = bigInteger5.modInverse(bigInteger4);
            bigIntegerArray = bigIntegerArray2;
            bigIntegerArray2[6] = bigInteger4.modInverse(bigInteger5);
        } else {
            BigInteger[] bigIntegerArray3 = new BigInteger[1];
            bigIntegerArray = bigIntegerArray3;
            bigIntegerArray3[0] = bigInteger;
        }
        super(bigIntegerArray, new BigInteger[]{bigInteger2, bigInteger3});
    }

    public KeyPair read(DataInputStream dataInputStream) throws IOException {
        BigInteger[][] bigIntegerArray = KeyPair.readKeys(dataInputStream);
        return bigIntegerArray[0].length > 1 ? new RSAKeyPair(bigIntegerArray[0][0], bigIntegerArray[1][0], bigIntegerArray[1][1], bigIntegerArray[0][1], bigIntegerArray[0][2]) : new RSAKeyPair(bigIntegerArray[0][0], bigIntegerArray[1][0], bigIntegerArray[1][1]);
    }

    public void write(OutputStream outputStream) throws IOException {
        super.write(new DataOutputStream(outputStream), this.getClass().getName());
    }

    public String keyType() {
        return "RSA-1024";
    }

    public BigInteger getD() {
        return this.x[0];
    }

    public BigInteger getE() {
        return this.y[0];
    }

    public BigInteger getN() {
        return this.y[1];
    }

    public BigInteger getP() {
        return this.x.length > 1 ? this.x[1] : null;
    }

    public BigInteger getQ() {
        return this.x.length > 1 ? this.x[2] : null;
    }

    public BigInteger getDmodPsub1() {
        return this.x.length > 1 ? this.x[3] : null;
    }

    public BigInteger getDmodQsub1() {
        return this.x.length > 1 ? this.x[4] : null;
    }

    public BigInteger getQinvmodP() {
        return this.x.length > 1 ? this.x[5] : null;
    }

    public BigInteger getPinvmodQ() {
        return this.x.length > 1 ? this.x[6] : null;
    }

    public static void main(String[] stringArray) throws Exception {
        RSAKeyPair rSAKeyPair = null;
        if (stringArray[0].equals("test")) {
            rSAKeyPair = RSAKeyPair.generate(BigInteger.valueOf(47L), BigInteger.valueOf(71L), true);
            BigInteger bigInteger = RSA.encrypt(rSAKeyPair, BigInteger.valueOf(688L));
            System.err.println("e(688)=" + bigInteger);
            System.err.println("d(" + bigInteger + ")=" + RSA.decrypt(rSAKeyPair, bigInteger));
            return;
        }
        if (stringArray[0].equals("read")) {
            File file = new File(stringArray[1]);
            rSAKeyPair = (RSAKeyPair)CryptoKey.read(new FileInputStream(file));
        } else {
            File file = new File(stringArray[0]);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            long l = System.currentTimeMillis();
            int n = 0;
            while (n < 1) {
                rSAKeyPair = RSAKeyPair.generate(1024, new Yarrow(), true);
                ++n;
            }
            System.err.println(System.currentTimeMillis() - l);
            rSAKeyPair.write(fileOutputStream);
            fileOutputStream.close();
        }
        System.err.println(rSAKeyPair.verboseToString());
    }
}

