/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.Core;
import Freenet.crypt.BlockCipher;
import Freenet.crypt.Digest;
import Freenet.crypt.SHA1;
import Freenet.support.Bucket;
import Freenet.support.Fields;
import Freenet.support.Loader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Random;

public class Util {
    public static char[] HEXCHARSET = "0123456789abcdef".toCharArray();
    public static final BigInteger ONE = BigInteger.valueOf(1L);
    public static final BigInteger ZERO = BigInteger.valueOf(0L);
    public static final BigInteger TWO = BigInteger.valueOf(2L);
    private static SHA1 ctx = new SHA1();
    public static byte[] ZERO_ARRAY = new byte[16384];

    static String quantityToHexString(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(HEXCHARSET[(int)(l & 0xFL)]);
            l >>= 4;
            ++n2;
        }
        stringBuffer.reverse();
        return stringBuffer.toString();
    }

    public static String intToHexString(int n) {
        return Util.quantityToHexString(n, 8);
    }

    public static String longToHexString(long l) {
        return Util.quantityToHexString(l, 16);
    }

    public static String byteToHexString(byte by) {
        return Util.quantityToHexString(by, 2);
    }

    public static byte[] stringToBytes(String string) throws NumberFormatException {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        while (n < cArray.length) {
            byArray[n * 2] = (byte)(cArray[n] >> 8 & 0xFF);
            byArray[n * 2 + 1] = (byte)cArray[n];
            ++n;
        }
        return byArray;
    }

    public static byte[] hexToBytes(String string) throws NumberFormatException {
        if (string.length() % 2 != 0) {
            string = "0" + string;
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        while (n < string.length()) {
            byte by;
            char c = Character.toLowerCase(string.charAt(n));
            if (!(c >= 'a' && c <= 'f' || c >= '0' && c <= '9')) {
                throw new NumberFormatException();
            }
            byte by2 = by = c >= 'a' && c <= 'f' ? (byte)(c - 97 + 10) : (byte)(c - 48);
            if (n % 2 == 0) {
                byArray[n / 2] = (byte)(by << 4);
            } else {
                byArray[(n - 1) / 2] = (byte)(byArray[(n - 1) / 2] | by);
            }
            ++n;
        }
        return byArray;
    }

    public static void fillByteArrayFromInts(int[] nArray, byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            byArray[n++] = (byte)(nArray[n2] >> 24);
            byArray[n++] = (byte)(nArray[n2] >> 16);
            byArray[n++] = (byte)(nArray[n2] >> 8);
            byArray[n++] = (byte)nArray[n2];
            ++n2;
        }
    }

    public static void fillByteArrayFromLongs(long[] lArray, byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < lArray.length) {
            byArray[n++] = (byte)(lArray[n2] >> 56);
            byArray[n++] = (byte)(lArray[n2] >> 48);
            byArray[n++] = (byte)(lArray[n2] >> 40);
            byArray[n++] = (byte)(lArray[n2] >> 32);
            byArray[n++] = (byte)(lArray[n2] >> 24);
            byArray[n++] = (byte)(lArray[n2] >> 16);
            byArray[n++] = (byte)(lArray[n2] >> 8);
            byArray[n++] = (byte)lArray[n2];
            ++n2;
        }
    }

    public static void fillIntArrayFromBytes(byte[] byArray, int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length << 2) {
            nArray[n++] = byArray[n2] + byArray[n2 + 1] << 8 + byArray[n2 + 2] << 16 + byArray[n2 + 3] << 24;
            n2 += 4;
        }
    }

    public static void fillLongArrayFromBytes(byte[] byArray, long[] lArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < lArray.length << 3) {
            lArray[n++] = (long)byArray[n2] + ((long)byArray[n2 + 1] << 8) + ((long)byArray[n2 + 2] << 16) + ((long)byArray[n2 + 3] << 24) + ((long)byArray[n2 + 4] << 32) + ((long)byArray[n2 + 5] << 40) + ((long)byArray[n2 + 6] << 48) + ((long)byArray[n2 + 7] << 56);
            n2 += 8;
        }
    }

    public static boolean byteArrayEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static byte[] MPIbytes(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = new byte[2 + (n + 7 >> 3)];
        System.arraycopy(byArray, byArray[0] == 0 ? 1 : 0, byArray2, 2, byArray2.length - 2);
        byArray2[0] = (byte)(n >> 8);
        byArray2[1] = (byte)n;
        return byArray2;
    }

    public static void writeMPI(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        int n = bigInteger.bitLength();
        byte[] byArray = Util.MPIbytes(bigInteger);
        outputStream.write(byArray);
    }

    public static BigInteger readMPI(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = ((n & 0xFF) << 8) + (n2 & 0xFF);
        byte[] byArray = new byte[(n3 + 7 >> 3) + 1];
        new DataInputStream(inputStream).readFully(byArray, 1, byArray.length - 1);
        return new BigInteger(byArray);
    }

    public static BigInteger generateLargeRandom(int n, int n2, Random random) {
        int n3;
        while ((n3 = (random.nextInt() & Integer.MAX_VALUE) % n2) < n) {
        }
        BigInteger bigInteger = new BigInteger(n3, random);
        return bigInteger;
    }

    public static BigInteger byteArrayToMPI(byte[] byArray) {
        byte[] byArray2;
        if (byArray[0] < 0) {
            byArray2 = new byte[byArray.length + 1];
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        } else {
            byArray2 = byArray;
        }
        return new BigInteger(byArray2);
    }

    public static byte[] hashString(Digest digest, String string) {
        try {
            byte[] byArray = string.getBytes("UTF8");
            digest.update(byArray, 0, byArray.length);
            return digest.digest();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static byte[] hashFile(Digest digest, File file) throws IOException, FileNotFoundException {
        byte[] byArray = new byte[65536];
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = 0;
        do {
            if ((n = fileInputStream.read(byArray)) <= 0) continue;
            digest.update(byArray, 0, n);
        } while (n != -1);
        return digest.digest();
    }

    public static void makeKey(byte[] byArray, byte[] byArray2, int n, int n2) {
        SHA1 sHA1 = ctx;
        synchronized (sHA1) {
            ctx.init();
            int n3 = 0;
            while (n2 > 0) {
                int n4;
                ++n3;
                int n5 = 0;
                while (n5 < n3) {
                    ctx.update((byte)0);
                    ++n5;
                }
                ctx.update(byArray, 0, byArray.length);
                if (n2 > 20) {
                    ctx.digest(true, byArray2, n);
                    n4 = 20;
                } else {
                    byte[] byArray3 = ctx.digest();
                    n4 = Math.min(n2, byArray3.length);
                    System.arraycopy(byArray3, 0, byArray2, n, n4);
                }
                n += n4;
                n2 -= n4;
            }
        }
        Util.wipe(byArray);
    }

    public static void makeKey(Bucket bucket, byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[Core.bufferSize];
        SHA1 sHA1 = ctx;
        synchronized (sHA1) {
            ctx.init();
            int n3 = 0;
            while (n2 > 0) {
                int n4;
                ++n3;
                int n5 = 0;
                while (n5 < n3) {
                    ctx.update((byte)0);
                    ++n5;
                }
                InputStream inputStream = bucket.getInputStream();
                int n6 = 0;
                while ((n6 = inputStream.read(byArray2)) > 0) {
                    ctx.update(byArray2, 0, byArray2.length);
                }
                inputStream.close();
                if (n2 > ctx.digestSize() >> 3) {
                    ctx.digest(true, byArray, n);
                    n4 = ctx.digestSize() >> 3;
                } else {
                    byte[] byArray3 = ctx.digest();
                    n4 = Math.min(n2, byArray3.length);
                    System.arraycopy(byArray3, 0, byArray, n, n4);
                }
                n += n4;
                n2 -= n4;
            }
        }
        Util.wipe(byArray2);
    }

    public static BlockCipher getCipherByName(String string) {
        try {
            Class clazz = Loader.load("Freenet.crypt.ciphers." + string);
            return (BlockCipher)clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Digest getDigestByName(String string) {
        try {
            Class clazz = Loader.load("Freenet.crypt." + string);
            return (Digest)clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0 || stringArray[0].equals("write")) {
            Util.writeMPI(new BigInteger("9"), System.out);
            Util.writeMPI(new BigInteger("1234567890123456789"), System.out);
            Util.writeMPI(new BigInteger("100200300400500600700800900"), System.out);
        } else if (stringArray[0].equals("read")) {
            System.out.println("9");
            System.out.println(Util.readMPI(System.in));
            System.out.println("1234567890123456789");
            System.out.println(Util.readMPI(System.in));
            System.out.println("100200300400500600700800900");
            System.out.println(Util.readMPI(System.in));
        } else if (stringArray[0].equals("write-mpi")) {
            Util.writeMPI(new BigInteger(stringArray[1]), System.out);
        } else if (stringArray[0].equals("read-mpi")) {
            System.err.println(Util.readMPI(System.in));
        } else if (stringArray[0].equals("keygen")) {
            byte[] byArray = Util.MPIbytes(Util.readMPI(System.in));
            byte[] byArray2 = new byte[stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 16];
            Util.makeKey(byArray, byArray2, 0, byArray2.length);
            System.err.println(Fields.bytesToHex(byArray2, 0, byArray2.length));
        } else if (stringArray[0].equals("shatest")) {
            SHA1 sHA1 = ctx;
            synchronized (sHA1) {
                ctx.init();
                ctx.update((byte)97);
                ctx.update((byte)98);
                ctx.update((byte)99);
                byte[] byArray = ctx.digest();
                System.err.println(Fields.bytesToHex(byArray, 0, byArray.length));
            }
        }
    }

    public static void wipe(byte[] byArray) {
        System.arraycopy(ZERO_ARRAY, 0, byArray, 0, byArray.length);
    }
}

