/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt.ciphers;

import Freenet.Core;
import Freenet.crypt.BlockCipher;
import Freenet.crypt.ciphers.Twofish_Algorithm;
import Freenet.support.Logger;
import java.security.InvalidKeyException;

public class Twofish
implements BlockCipher {
    private Object sessionKey;
    private int keysize;

    public Twofish(int n) {
        if (n != 64 && n != 128 && n != 192 && n != 256) {
            throw new RuntimeException("Invalid keysize");
        }
        this.keysize = n;
    }

    public Twofish() {
        this(128);
    }

    public int getBlockSize() {
        return 128;
    }

    public int getKeySize() {
        return this.keysize;
    }

    public void initialize(byte[] byArray) {
        try {
            byte[] byArray2 = new byte[this.keysize >> 3];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            this.sessionKey = Twofish_Algorithm.makeKey(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
            Core.logger.log(this, "Invalid key", Logger.ERROR);
        }
    }

    public byte[] encipher(byte[] byArray) {
        return Twofish_Algorithm.blockEncrypt(byArray, 0, this.sessionKey);
    }

    public byte[] decipher(byte[] byArray) {
        return Twofish_Algorithm.blockDecrypt(byArray, 0, this.sessionKey);
    }
}

