/*
 * Decompiled with CFR 0.152.
 */
package Freenet.message;

import Freenet.ConduitException;
import Freenet.ConnectFailedException;
import Freenet.ConnectionHandler;
import Freenet.Core;
import Freenet.InvalidMessageException;
import Freenet.Key;
import Freenet.MessageMemory;
import Freenet.MessageObject;
import Freenet.Presentation;
import Freenet.RawMessage;
import Freenet.SendFailedException;
import Freenet.message.DataReply;
import Freenet.message.KeyedMM;
import Freenet.message.Request;
import Freenet.message.RequestAbortException;
import Freenet.message.StoreData;
import Freenet.node.Entity;
import Freenet.node.Node;
import Freenet.node.NodeMessageObject;
import Freenet.node.NodeReference;
import Freenet.support.Logger;
import java.io.IOException;
import java.io.InputStream;

public class DataRequest
extends Request {
    public static final String messageName = "DataRequest";

    public DataRequest(long l, long l2, long l3, Key key) {
        super(l, l2, l3, key);
    }

    public DataRequest(RawMessage rawMessage) throws InvalidMessageException {
        super(rawMessage);
    }

    public RawMessage toRawMessage(Presentation presentation) {
        RawMessage rawMessage = super.toRawMessage(presentation);
        rawMessage.messageType = messageName;
        return rawMessage;
    }

    protected void refFound(NodeReference nodeReference, Node node, KeyedMM keyedMM) throws RequestAbortException {
    }

    protected void dataFound(Entity entity, Node node, KeyedMM keyedMM) throws RequestAbortException {
        Core.logger.log(this, "Found " + this.searchKey + " replying", Logger.MINOR);
        DataReply dataReply = null;
        long l = Math.abs(Core.randSource.nextInt() % 200);
        try {
            dataReply = new DataReply(this.id, this.depth, l, entity);
        }
        catch (Exception exception) {
            Core.logger.log(this, "Error loading " + this.searchKey + " from DataStore: " + exception, Logger.ERROR);
            return;
        }
        try {
            ConnectionHandler connectionHandler;
            DataSent dataSent = new DataSent(l, keyedMM.rr, dataReply.in);
            if (this.receivedWith == null) {
                connectionHandler = node.makeConnection(this.source);
                dataReply.keepAlive = false;
            } else {
                connectionHandler = !this.receivedWith.isOpen() ? node.makeConnection(this.source) : this.receivedWith;
            }
            dataReply.sending(node, connectionHandler);
            connectionHandler.sendMessage(dataReply, dataSent);
        }
        catch (ConnectFailedException connectFailedException) {
            Core.logger.log(this, "Error connecting to send DataReply to " + connectFailedException.peer, Logger.MINOR);
        }
        catch (SendFailedException sendFailedException) {
            Core.logger.log(this, "Error sending DataReply to " + sendFailedException.peer, Logger.MINOR);
        }
        throw new RequestAbortException(keyedMM);
    }

    private class DataSent
    implements NodeMessageObject {
        private MessageObject mo;
        private InputStream in;
        private long repDepth;
        private Exception e;

        public DataSent(long l, MessageObject messageObject, InputStream inputStream) {
            this.mo = messageObject;
            this.repDepth = l;
            this.in = inputStream;
        }

        public long id() {
            return DataRequest.this.id;
        }

        public MessageMemory received(Node node, MessageMemory messageMemory) {
            if (messageMemory == null || !(messageMemory instanceof KeyedMM)) {
                Core.logger.log(this, "DataSent object called incorrectly", Logger.ERROR);
                return messageMemory;
            }
            KeyedMM keyedMM = (KeyedMM)messageMemory;
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            node.sh.removeReader(DataRequest.this.searchKey, DataRequest.this.id);
            if (this.e == null) {
                Core.logger.log(this, "data sent correctly", Logger.DEBUGGING);
                try {
                    StoreData storeData = new StoreData(DataRequest.this.id, DataRequest.this.depth, this.repDepth, null);
                    storeData.resetDataSource(true);
                    ConnectionHandler connectionHandler = keyedMM.replyCon == null || !keyedMM.replyCon.isOpen() ? node.makeConnection(keyedMM.origRec) : keyedMM.replyCon;
                    storeData.sending(node, connectionHandler);
                    connectionHandler.unlockedSend(storeData, null);
                }
                catch (ConnectFailedException connectFailedException) {
                    Core.logger.log(this, "Failed to send back StoreData message to " + connectFailedException.peer, Logger.MINOR);
                }
                catch (SendFailedException sendFailedException) {
                    Core.logger.log(this, "Failed to send back StoreData message to " + sendFailedException.peer, Logger.MINOR);
                }
                keyedMM.state = 60;
            } else if (this.e instanceof ConduitException) {
                ConduitException conduitException = (ConduitException)this.e;
                if (conduitException.inRead()) {
                    try {
                        conduitException.getOutStream().write(1);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    node.sh.removeReader(DataRequest.this.searchKey, DataRequest.this.id);
                    if (this.mo == null) {
                        node.timer.add(0L, this.mo);
                    }
                } else {
                    Core.logger.log(this, "Send of data for reply failed when connection to next node died!", Logger.MINOR);
                }
            } else {
                Core.logger.log(this, "Send failed on unknown exception " + this.e, Logger.NORMAL);
            }
            return keyedMM;
        }

        public void setException(Exception exception) {
            this.e = exception;
        }
    }
}

