/*
 * Decompiled with CFR 0.152.
 */
package Freenet.message;

import Freenet.Address;
import Freenet.BadAddressException;
import Freenet.Conduit;
import Freenet.ConduitException;
import Freenet.ConnectFailedException;
import Freenet.Core;
import Freenet.FieldSet;
import Freenet.InvalidMessageException;
import Freenet.Message;
import Freenet.MessageMemory;
import Freenet.Presentation;
import Freenet.RawMessage;
import Freenet.SendFailedException;
import Freenet.message.KeyedMM;
import Freenet.message.SendDone;
import Freenet.node.BadDataException;
import Freenet.node.DataProperties;
import Freenet.node.Entity;
import Freenet.node.Node;
import Freenet.node.NodeMessageObject;
import Freenet.support.Fields;
import Freenet.support.Logger;
import Freenet.support.io.DataNotValidIOException;
import Freenet.support.io.PadOnErrorInputStream;
import Freenet.support.io.SplitOutputStream;
import Freenet.support.io.VerifyingInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class DataSend
extends Message {
    public InputStream in = null;
    public long length = 0L;
    private Entity cache;
    private SplitOutputStream datatunnel;

    public DataSend(long l, long l2, long l3, FieldSet fieldSet) {
        super(l, l2, l3, fieldSet);
    }

    public DataSend(long l, long l2, long l3, Entity entity) throws BadDataException, IOException {
        super(l, l2, l3, new FieldSet());
        if (entity.props() != null) {
            try {
                FieldSet fieldSet = entity.props().restore();
                this.otherFields.add("Storable", fieldSet);
            }
            catch (DataProperties.WrongOrderException wrongOrderException) {
                // empty catch block
            }
        }
        this.length = entity.data().getLength();
        this.in = entity.data().getInputStream();
    }

    public DataSend(RawMessage rawMessage) throws InvalidMessageException, BadAddressException {
        super(rawMessage);
        if (rawMessage.trailingFieldLength == 0L) {
            throw new InvalidMessageException("Data sending message requires the trailing field length to be specified");
        }
        this.length = rawMessage.trailingFieldLength;
        if (rawMessage.trailingFieldName != null) {
            this.in = rawMessage.trailingFieldStream;
        }
        if (this.in == null) {
            throw new InvalidMessageException("Data sending message requires a trailing field called Data");
        }
    }

    public RawMessage toRawMessage(Presentation presentation) {
        RawMessage rawMessage = super.toRawMessage(presentation);
        if (this.in != null) {
            rawMessage.trailingFieldStream = this.in;
            rawMessage.trailingFieldLength = this.length;
            rawMessage.trailingFieldName = "Data";
        }
        return rawMessage;
    }

    public MessageMemory pReceived(Node node, MessageMemory messageMemory) {
        if (messageMemory == null || !(messageMemory instanceof KeyedMM)) {
            if (this.receivedWith != null) {
                this.receivedWith.close();
            }
            this.in.notify();
            return null;
        }
        KeyedMM keyedMM = (KeyedMM)messageMemory;
        if (keyedMM.rr != null) {
            keyedMM.rr.cancel();
        }
        if (keyedMM.state > 20) {
            Core.logger.log(this, "Received a second DataSend for the same chain", Logger.MINOR);
            return keyedMM;
        }
        try {
            this.cacheData(node, keyedMM);
        }
        catch (DataNotValidIOException dataNotValidIOException) {
            return keyedMM;
        }
        catch (IOException iOException) {
            Core.logger.log(this, "Error while caching data: " + iOException, Logger.ERROR);
            return keyedMM;
        }
        if (keyedMM.dataref != null || keyedMM.replyCon != null) {
            try {
                this.in = this.cache.data().getInputStream();
            }
            catch (IOException iOException) {
                if (keyedMM.rr != null) {
                    node.timer.add(0L, keyedMM.rr);
                }
                Core.logger.log(this, "Could not restore data from cache, restarting request", Logger.NORMAL);
                return keyedMM;
            }
            try {
                if (keyedMM.dataCon == null || !keyedMM.dataCon.isOpen()) {
                    keyedMM.dataCon = node.makeConnection(keyedMM.dataref);
                }
                this.sending(node, keyedMM.dataCon);
                SendDone sendDone = this.getSendDone(this.in);
                keyedMM.dataCon.sendMessage(this, sendDone);
            }
            catch (ConnectFailedException connectFailedException) {
                Core.logger.log(this, "Couldn't restore connection to proxy data to " + connectFailedException.peer, Logger.NORMAL);
            }
            catch (SendFailedException sendFailedException) {
                Core.logger.log(this, "Couldn't proxy data to " + sendFailedException.peer, Logger.NORMAL);
            }
        } else {
            Core.logger.log(this, "Message ends here", Logger.DEBUGGING);
        }
        return keyedMM;
    }

    public void sending(Core core, Address address, Address address2) throws SendFailedException {
        if (address2.equals(address)) {
            throw new SendFailedException(address);
        }
        this.source = address2;
    }

    protected MessageMemory timeOut(Node node, MessageMemory messageMemory) {
        if (messageMemory != null && messageMemory instanceof KeyedMM && node.ds.searchData(((KeyedMM)messageMemory).searchKey) == null) {
            KeyedMM keyedMM = (KeyedMM)messageMemory;
            if (keyedMM.rr != null) {
                keyedMM.rr.cancel();
            }
            try {
                this.cacheData(node, keyedMM);
            }
            catch (IOException iOException) {
                Core.logger.log(this, "Error while caching data: " + iOException, Logger.ERROR);
                return null;
            }
        } else {
            Core.logger.log(this, "Unknown DataSend, not saving", Logger.DEBUGGING);
            if (this.receivedWith != null) {
                this.receivedWith.close();
            }
            this.in.notify();
        }
        return messageMemory;
    }

    private void cacheData(Node node, KeyedMM keyedMM) throws DataNotValidIOException, IOException {
        VerifyingInputStream verifyingInputStream;
        this.datatunnel = new SplitOutputStream();
        FieldSet fieldSet = this.otherFields.getSet("Storable");
        long l = fieldSet != null && fieldSet.get("PartSize") != null ? Fields.stringToLong(fieldSet.get("PartSize")) : 0L;
        keyedMM.data = this.cache = node.ds.newEntity(this.datatunnel, this.length, l);
        DataProperties dataProperties = this.cache.props();
        try {
            verifyingInputStream = keyedMM.searchKey.verifyStream(new PadOnErrorInputStream(this.in), fieldSet, this.length);
        }
        catch (DataNotValidIOException dataNotValidIOException) {
            Core.logger.log(this, "Caching failed on invalid data, attempting to restart request", Logger.NORMAL);
            if (keyedMM.rr != null) {
                node.timer.add(0L, keyedMM.rr);
            }
            throw dataNotValidIOException;
        }
        if (fieldSet != null) {
            try {
                dataProperties.store(fieldSet);
            }
            catch (DataProperties.WrongOrderException wrongOrderException) {
                Core.logger.log(this, "Tried to write to full DataProperties element?!?!?", Logger.MINOR);
            }
        }
        keyedMM.state = 30;
        ReceivedData receivedData = new ReceivedData(this.in);
        new Conduit(verifyingInputStream, this.datatunnel, node.mh).asyncFeed(receivedData, this.length);
    }

    protected abstract SendDone getSendDone(InputStream var1);

    private class ReceivedData
    implements NodeMessageObject {
        private InputStream fromCon;
        private Exception e;

        public ReceivedData(InputStream inputStream) {
            this.fromCon = inputStream;
        }

        public long id() {
            return DataSend.this.id;
        }

        public MessageMemory received(Node node, MessageMemory messageMemory) {
            Core.logger.log(this, "Data signaled as receive done", Logger.DEBUGGING);
            if (messageMemory == null || !(messageMemory instanceof KeyedMM) || ((KeyedMM)messageMemory).state < 30) {
                Core.logger.log(this, "Data receive object handled at wrong time!", Logger.ERROR);
                return messageMemory;
            }
            KeyedMM keyedMM = (KeyedMM)messageMemory;
            if (this.e == null) {
                Core.logger.log(this, "Data received successfully!", Logger.DEBUGGING);
                keyedMM.state = 40;
                try {
                    DataSend.this.cache.data().stop();
                }
                catch (IOException iOException) {
                    Core.logger.log(this, "Error closing cache object although stream signaled finished", Logger.ERROR);
                }
                InputStream inputStream = this.fromCon;
                synchronized (inputStream) {
                    this.fromCon.notifyAll();
                }
                return keyedMM.storeData != null ? keyedMM.storeData.pReceived(node, keyedMM) : keyedMM;
            }
            if (!(this.e instanceof ConduitException)) {
                return keyedMM;
            }
            ConduitException conduitException = (ConduitException)this.e;
            if (conduitException.inRead()) {
                try {
                    if (conduitException.getIOException() instanceof DataNotValidIOException) {
                        int n = ((DataNotValidIOException)conduitException.getIOException()).getCode();
                        Core.logger.log(this, "Got DNV(" + n + ")", Logger.DEBUGGING);
                        if (n == 0) {
                            if (DataSend.this.receivedWith != null) {
                                DataSend.this.receivedWith.close();
                            }
                            conduitException.getOutStream().write(129);
                            DataSend.this.cache.data().stopStreams(129);
                        } else if (n == 1) {
                            conduitException.getOutStream().write(n);
                            DataSend.this.cache.data().stopStreams(n);
                        }
                    } else if (this.e instanceof IOException) {
                        Core.logger.log(this, "Read from CIS threw IOException: " + this.e + ". This should never happen (padding).", Logger.ERROR);
                        if (DataSend.this.receivedWith != null) {
                            DataSend.this.receivedWith.close();
                        }
                        conduitException.getOutStream().write(130);
                        DataSend.this.cache.data().stopStreams(130);
                    }
                    DataSend.this.cache.data().stop();
                }
                catch (IOException iOException) {
                    Core.logger.log(this, "Error writing CB to cache on error in stream", Logger.ERROR);
                }
            } else {
                Core.logger.log(this, "Error writing to cache!", Logger.ERROR);
            }
            InputStream inputStream = this.fromCon;
            synchronized (inputStream) {
                this.fromCon.notifyAll();
            }
            keyedMM.state = 35;
            return keyedMM.sendDone != null ? keyedMM.sendDone.received(node, keyedMM) : keyedMM;
        }

        public void setException(Exception exception) {
            this.e = exception;
        }
    }
}

