/*
 * Decompiled with CFR 0.152.
 */
package Freenet.message;

import Freenet.Address;
import Freenet.BadAddressException;
import Freenet.ConnectFailedException;
import Freenet.ConnectionHandler;
import Freenet.Core;
import Freenet.InvalidMessageException;
import Freenet.Key;
import Freenet.KeyException;
import Freenet.Message;
import Freenet.MessageMemory;
import Freenet.Presentation;
import Freenet.RawMessage;
import Freenet.SendFailedException;
import Freenet.message.KeyedMM;
import Freenet.message.RequestAbortException;
import Freenet.message.RequestFailed;
import Freenet.message.RequestRestarted;
import Freenet.message.TimedOut;
import Freenet.node.Entity;
import Freenet.node.Node;
import Freenet.node.NodeReference;
import Freenet.support.Logger;
import java.util.Vector;

public abstract class Request
extends Message {
    public Key searchKey;

    public Request(long l, long l2, long l3, Key key) {
        super(l, l2, l3, null);
        this.searchKey = key;
    }

    public Request(RawMessage rawMessage) throws InvalidMessageException {
        super(rawMessage);
        String string = this.otherFields.get("SearchKey");
        if (string.equals("")) {
            throw new InvalidMessageException("Can't find SearchKey field");
        }
        try {
            this.searchKey = Key.readKey(string);
        }
        catch (KeyException keyException) {
            throw new InvalidMessageException("Failed to load key: " + keyException);
        }
    }

    public RawMessage toRawMessage(Presentation presentation) {
        RawMessage rawMessage = super.toRawMessage(presentation);
        rawMessage.fs.add("SearchKey", this.searchKey.toString());
        return rawMessage;
    }

    protected MessageMemory pReceived(Node node, MessageMemory messageMemory) {
        if (messageMemory != null) {
            Core.logger.log(this, "loop - backtracking", Logger.MINOR);
            RequestFailed requestFailed = new RequestFailed(this.id, this.hopsToLive, this.otherFields);
            try {
                this.sendReply(node, requestFailed);
            }
            catch (SendFailedException sendFailedException) {
                Core.logger.log(this, "Return to " + sendFailedException.peer + " failed on loop", Logger.NORMAL);
            }
            return messageMemory;
        }
        RequestRestarted requestRestarted = new RequestRestarted(this.id, this.hopsToLive);
        KeyedMM keyedMM = new KeyedMM(this.source, this.depth, this.receivedWith, this.searchKey, null, this.getClass(), requestRestarted);
        try {
            this.searchData(node, this.searchKey, keyedMM);
        }
        catch (RequestAbortException requestAbortException) {
            return requestAbortException.mm;
        }
        Core.logger.log(this, "Forwarding query for " + this.searchKey, Logger.DEBUG);
        if (this.sentToNextBest(keyedMM, node, null)) {
            node.timer.add(RequestRestarted.getTime(this.hopsToLive), requestRestarted);
        }
        keyedMM.state = 10;
        return keyedMM;
    }

    protected boolean sentToNextBest(KeyedMM keyedMM, Node node, RequestFailed requestFailed) {
        Object object;
        Address address;
        Vector<Key> vector = new Vector<Key>();
        while (true) {
            keyedMM.prevAttempt = keyedMM.lastAttempt;
            keyedMM.lastAttempt = node.ds.findClosestKey(keyedMM.searchKey, keyedMM.lastAttempt);
            try {
                NodeReference nodeReference = node.ds.searchRef(keyedMM.lastAttempt);
                address = nodeReference == null ? null : nodeReference.getAddress();
            }
            catch (BadAddressException badAddressException) {
                address = null;
            }
            if (keyedMM.lastAttempt != null && (address == null || address.equals(keyedMM.origRec) || keyedMM.usedAddresses.contains(address))) continue;
            if (keyedMM.lastAttempt == null) {
                Core.logger.log(this, "Giving up send of " + Long.toHexString(this.id) + ", returning to " + keyedMM.origRec, Logger.MINOR);
                if (requestFailed == null) {
                    requestFailed = new RequestFailed(this.id, this.hopsToLive, this.otherFields);
                }
                try {
                    requestFailed.sendBack(node, keyedMM);
                }
                catch (SendFailedException sendFailedException) {
                    Core.logger.log(this, "Return to " + sendFailedException.peer + " failed on no more references", Logger.NORMAL);
                }
                return false;
            }
            keyedMM.usedAddresses.addElement(address);
            boolean bl = false;
            Core.logger.log(this, "Forwarding query to " + address, Logger.DEBUG);
            try {
                object = node.makeConnection(address);
                this.sending(node, (ConnectionHandler)object);
                ((ConnectionHandler)object).sendMessage(this);
            }
            catch (ConnectFailedException connectFailedException) {
                vector.addElement(keyedMM.lastAttempt);
                bl = true;
            }
            catch (SendFailedException sendFailedException) {
                vector.addElement(keyedMM.lastAttempt);
                bl = true;
            }
            if (!bl) break;
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            Key key = (Key)object.nextElement();
            Core.logger.log(this, "Removing link for ref " + key, Logger.DEBUG);
            node.ds.removeRef(key);
        }
        keyedMM.lastAddr = address;
        return true;
    }

    protected MessageMemory timeOut(Node node, MessageMemory messageMemory) {
        KeyedMM keyedMM = new KeyedMM(this.source, this.depth, this.receivedWith, this.searchKey, null, this.getClass(), new RequestRestarted(this.id, 1L));
        try {
            this.searchData(node, this.searchKey, keyedMM);
        }
        catch (RequestAbortException requestAbortException) {
            return requestAbortException.mm;
        }
        return super.timeOut(node, messageMemory);
    }

    public static KeyedMM failedTimedOut(Node node, long l, KeyedMM keyedMM) {
        if (keyedMM.rr != null) {
            keyedMM.rr.cancel();
        }
        TimedOut timedOut = new TimedOut(l, keyedMM.depth);
        try {
            timedOut.sendBack(node, keyedMM);
        }
        catch (SendFailedException sendFailedException) {
            Core.logger.log(null, "Request, Sending of timeout to Failed message failed", Logger.NORMAL);
        }
        return null;
    }

    public void searchData(Node node, Key key, KeyedMM keyedMM) throws RequestAbortException {
        Entity entity = node.sh.find(key);
        if (entity != null) {
            this.dataFound(entity, node, keyedMM);
        } else {
            entity = node.sh.find(key);
            if (entity != null || (entity = node.ds.searchData(key)) != null) {
                this.dataFound(entity, node, keyedMM);
            } else {
                NodeReference nodeReference = node.ds.searchRef(key);
                if (nodeReference != null) {
                    this.refFound(nodeReference, node, keyedMM);
                }
            }
        }
    }

    protected abstract void refFound(NodeReference var1, Node var2, KeyedMM var3) throws RequestAbortException;

    protected abstract void dataFound(Entity var1, Node var2, KeyedMM var3) throws RequestAbortException;
}

