/*
 * Decompiled with CFR 0.152.
 */
package Freenet.message;

import Freenet.Core;
import Freenet.MessageMemory;
import Freenet.SendFailedException;
import Freenet.message.KeyedMM;
import Freenet.message.QueryRestarted;
import Freenet.message.RequestFailed;
import Freenet.node.Node;
import Freenet.node.NodeMessageObject;
import Freenet.support.Logger;
import Freenet.support.Schedulable;
import Freenet.support.TickerToken;

public class RequestRestarted
implements Schedulable,
NodeMessageObject {
    private long id;
    private long hopsToLive;
    private TickerToken tt;

    public static long getTime(long l) {
        return (long)((double)((long)Core.hopTimeExpected * l) + 1.28 * Math.sqrt(l) * (double)Core.hopTimeDeviation);
    }

    public RequestRestarted(long l, long l2) {
        this.id = l;
        this.hopsToLive = l2;
    }

    public long id() {
        return this.id;
    }

    public long hopsToLive() {
        return this.hopsToLive;
    }

    public MessageMemory received(Node node, MessageMemory messageMemory) {
        if (messageMemory == null || !(messageMemory instanceof KeyedMM)) {
            Core.logger.log(this, "No MM available to restart message", Logger.MINOR);
            return messageMemory;
        }
        KeyedMM keyedMM = (KeyedMM)messageMemory;
        try {
            Core.logger.log(this, "Restarting request " + Long.toHexString(this.id), Logger.DEBUGGING);
            node.ds.removeRef(keyedMM.lastAttempt);
            QueryRestarted queryRestarted = new QueryRestarted(this.id, messageMemory.depth);
            queryRestarted.sendBack(node, messageMemory);
            RequestFailed requestFailed = new RequestFailed(this.id, this.hopsToLive, null);
            keyedMM.state = 10;
            keyedMM.lastAttempt = keyedMM.prevAttempt;
            return requestFailed.received(node, keyedMM);
        }
        catch (SendFailedException sendFailedException) {
            Core.logger.log(this, "Couldn't restart on timeout because send failed to " + sendFailedException.peer, Logger.NORMAL);
            return messageMemory;
        }
    }

    public void setException(Exception exception) {
    }

    public void getToken(TickerToken tickerToken) {
        this.tt = tickerToken;
    }

    public boolean cancel() {
        return this.tt != null && this.tt.cancel();
    }

    public void setHopsToLive(long l) {
        this.hopsToLive = l;
    }
}

