/*
 * Decompiled with CFR 0.152.
 */
package Freenet.message;

import Freenet.ConduitException;
import Freenet.Core;
import Freenet.MessageMemory;
import Freenet.message.KeyedMM;
import Freenet.node.Node;
import Freenet.node.NodeMessageObject;
import Freenet.support.Logger;
import java.io.IOException;
import java.io.InputStream;

abstract class SendDone
implements NodeMessageObject {
    protected long id;
    private InputStream in;
    private Exception e = null;

    protected SendDone(long l, InputStream inputStream) {
        this.id = l;
        this.in = inputStream;
    }

    public long id() {
        return this.id;
    }

    public final MessageMemory received(Node node, MessageMemory messageMemory) {
        Core.logger.log(this, "Send signaled ended.", Logger.DEBUGGING);
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            Core.logger.log(this, "IOException when closing input: " + iOException, Logger.DEBUGGING);
        }
        if (messageMemory == null || !(messageMemory instanceof KeyedMM) || ((KeyedMM)messageMemory).state < 30 || ((KeyedMM)messageMemory).state >= 60) {
            Core.logger.log(this, "Called to handle SendDone incorrectly", Logger.ERROR);
            return messageMemory;
        }
        KeyedMM keyedMM = (KeyedMM)messageMemory;
        node.sh.removeReader(keyedMM.searchKey, this.id);
        if (this.e == null) {
            Core.logger.log(this, "Send Successful!", Logger.DEBUGGING);
            if (keyedMM.state < 50) {
                Core.logger.log(this, "SendDone handeling being postponed.", Logger.DEBUGGING);
                keyedMM.sendDone = this;
                return keyedMM;
            }
            return this.sendFinished(node, keyedMM);
        }
        Core.logger.log(this, "Exception occured during send!", Logger.DEBUGGING);
        if (!(this.e instanceof ConduitException)) {
            Core.logger.log(this, "Got exception " + this.e + " which I don't know what to do with.", Logger.MINOR);
            return keyedMM;
        }
        ConduitException conduitException = (ConduitException)this.e;
        if (keyedMM.state < 35) {
            Core.logger.log(this, "SendDone handeling being postponed.", Logger.DEBUGGING);
            keyedMM.sendDone = this;
            return keyedMM;
        }
        if (keyedMM.state >= 40 && conduitException.inRead()) {
            Core.logger.log(this, "Read from cache failed although the data was received fully, in state " + keyedMM.state, Logger.ERROR);
        }
        MessageMemory messageMemory2 = this.sendFailed(node, keyedMM, conduitException);
        try {
            conduitException.getInStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Core.logger.log(this, "Returning", Logger.DEBUGGING);
        return messageMemory2;
    }

    public void setException(Exception exception) {
        this.e = exception;
    }

    protected abstract MessageMemory sendFinished(Node var1, KeyedMM var2);

    protected abstract MessageMemory sendFailed(Node var1, KeyedMM var2, ConduitException var3);
}

