/*
 * Decompiled with CFR 0.152.
 */
package Freenet.message;

import Freenet.Address;
import Freenet.BadAddressException;
import Freenet.Core;
import Freenet.InvalidMessageException;
import Freenet.Message;
import Freenet.MessageMemory;
import Freenet.Presentation;
import Freenet.RawMessage;
import Freenet.SendFailedException;
import Freenet.message.KeyedMM;
import Freenet.node.Node;
import Freenet.node.NodeReference;
import Freenet.support.Logger;

public class StoreData
extends Message {
    public static final String messageName = "StoreData";
    public NodeReference dataSource;
    private boolean resetDS;

    public StoreData(long l, long l2, long l3) {
        this(l, l2, l3, (NodeReference)null);
    }

    public StoreData(long l, long l2, long l3, NodeReference nodeReference) {
        super(l, l2, l3, null);
        this.dataSource = nodeReference;
        this.keepAlive = false;
    }

    public StoreData(RawMessage rawMessage) throws InvalidMessageException, BadAddressException {
        super(rawMessage);
        String string = this.otherFields.get("DataSource");
        this.otherFields.remove("DataSource");
        this.dataSource = string == null ? null : new NodeReference(string);
        this.keepAlive = false;
    }

    public RawMessage toRawMessage(Presentation presentation) {
        RawMessage rawMessage = super.toRawMessage(presentation);
        if (this.dataSource != null) {
            rawMessage.fs.add("DataSource", this.dataSource.toString());
        }
        rawMessage.messageType = messageName;
        return rawMessage;
    }

    public MessageMemory pReceived(Node node, MessageMemory messageMemory) {
        if (messageMemory == null || !(messageMemory instanceof KeyedMM)) {
            Core.logger.log(this, "Got unexpected StoreData message!", Logger.NORMAL);
            return messageMemory;
        }
        KeyedMM keyedMM = (KeyedMM)messageMemory;
        if (keyedMM.data == null || keyedMM.state < 30) {
            Core.logger.log(this, "Got StoreData message for data that I have not received yet", Logger.DEBUGGING);
            return keyedMM;
        }
        if (keyedMM.state > 50) {
            Core.logger.log(this, "Got StoreData message for data that I have already stored", Logger.MINOR);
            return keyedMM;
        }
        if (keyedMM.state < 40) {
            Core.logger.log(this, "Postponing store while waiting for data to be received", Logger.DEBUGGING);
            keyedMM.storeData = this;
            return keyedMM;
        }
        if (keyedMM.data.data().isReadable() && node.ds.searchData(keyedMM.searchKey) == null) {
            Core.logger.log(this, "Received data for " + Long.toHexString(this.id) + " adding to DataStore", Logger.DEBUGGING);
            NodeReference nodeReference = this.dataSource != null ? this.dataSource : new NodeReference(keyedMM.lastAddr);
            node.ds.put(keyedMM.searchKey, nodeReference, keyedMM.data);
        } else {
            Core.logger.log(this, "Not caching data for " + Long.toHexString(this.id) + ", bad data stream or data I already have.", Logger.NORMAL);
            Core.logger.log(this, "cache.isReadable: " + keyedMM.data.data().isReadable() + ", n.ds.searchData(key): " + node.ds.searchData(keyedMM.searchKey) + ", kmm.state: " + keyedMM.state, Logger.DEBUGGING);
        }
        keyedMM.state = 50;
        keyedMM.storeData = this;
        return keyedMM.sendDone != null ? keyedMM.sendDone.received(node, keyedMM) : keyedMM;
    }

    public MessageMemory timeOut(Node node, MessageMemory messageMemory) {
        return this.pReceived(node, messageMemory);
    }

    public boolean resetDataSource(boolean bl) {
        boolean bl2 = this.resetDS;
        this.resetDS = bl;
        return bl2;
    }

    public void sending(Core core, Address address, Address address2) throws SendFailedException {
        if (address2.equals(address)) {
            throw new SendFailedException(address);
        }
        this.source = address2;
        if (this.resetDS || this.receivedAt != null && this.receivedAt.equalsHost(address2)) {
            if (core.getTransience()) {
                Core.logger.log(this, "Not resetting DataSource, Node is transient.", Logger.DEBUGGING);
            }
            if (core instanceof Node && ((Node)core).myRef != null) {
                Core.logger.log(this, "Not resetting DataSource, I'm not a Node!", Logger.DEBUGGING);
            }
            this.dataSource = core.getTransience() ? null : (core instanceof Node && ((Node)core).myRef != null ? ((Node)core).myRef : new NodeReference(address2));
        }
    }
}

