/*
 * Decompiled with CFR 0.152.
 */
package Freenet.node;

import Freenet.Core;
import Freenet.node.BadDataException;
import Freenet.node.Data;
import Freenet.support.Fields;
import Freenet.support.Logger;
import Freenet.support.io.ControlInputStream;
import Freenet.support.io.SplitOutputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class FileData
implements Data,
Serializable {
    public static File path;
    private boolean incomplete = false;
    private transient Vector readers = new Vector();
    protected File name;
    protected long length;
    protected long partLength;
    protected transient OutputStream toFile;

    public FileData(File file) {
        this.name = file;
        this.length = file.length();
    }

    public FileData(SplitOutputStream splitOutputStream, long l, long l2) throws IOException {
        this.length = l;
        this.partLength = l2;
        try {
            FileOutputStream fileOutputStream = this.newFile();
            this.toFile = fileOutputStream;
            splitOutputStream.addOutput(fileOutputStream);
        }
        catch (Exception exception) {
            Core.logger.log(this, "Exception creating file for caching stream!", Logger.ERROR);
            throw new IOException();
        }
    }

    private FileOutputStream newFile() throws IOException {
        String string;
        boolean bl;
        if (this.name != null) {
            return null;
        }
        String[] stringArray = path.list();
        do {
            string = "t" + Math.abs(Core.randSource.nextInt() % 10000000);
            bl = false;
            if (stringArray == null) continue;
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    bl = true;
                }
                ++n;
            }
        } while (bl);
        this.name = new File(path, string);
        Core.logger.log(this, "Created new file " + this.name, Logger.DEBUGGING);
        return new FileOutputStream(this.name);
    }

    public boolean isReadable() {
        return !this.incomplete;
    }

    public long getLength() throws BadDataException {
        if (this.incomplete) {
            throw new BadDataException();
        }
        return this.length;
    }

    public ControlInputStream getInputStream() throws BadDataException, IOException {
        Core.logger.log(this, "Returning new stream from data, length: 0x" + Fields.longToString(this.length) + " partLength: 0x" + Fields.longToString(this.partLength), Logger.DEBUGGING);
        if (this.incomplete) {
            throw new BadDataException();
        }
        ControlInputStream controlInputStream = new ControlInputStream(new FDataInputStream(), this.partLength, this.length);
        this.readers.addElement(controlInputStream);
        return controlInputStream;
    }

    public void stop() throws IOException {
        try {
            this.toFile.close();
            Object var2_1 = null;
            if (this.name.length() < this.length) {
                this.incomplete = true;
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.name.length() < this.length) {
                this.incomplete = true;
            }
            throw throwable;
        }
    }

    public void stopStreams(int n) {
        Enumeration enumeration = this.readers.elements();
        while (enumeration.hasMoreElements()) {
            ControlInputStream controlInputStream = (ControlInputStream)enumeration.nextElement();
            controlInputStream.endWithNextControl(n);
        }
    }

    public String toString() {
        return this.name.toString();
    }

    public String fileName() {
        return this.name.toString();
    }

    protected void finalize() throws Throwable {
        this.name.delete();
        super.finalize();
    }

    private class FDataInputStream
    extends FilterInputStream {
        private long read = 0L;
        private boolean closed = false;

        public FDataInputStream() throws IOException {
            super(new BufferedInputStream(new FileInputStream(FileData.this.name)));
        }

        public int read() throws IOException {
            if (!this.closed && this.read < FileData.this.length) {
                while (this.in.available() == 0) {
                    if (FileData.this.incomplete) {
                        this.remove();
                        throw new BadDataException();
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException();
                    }
                }
                ++this.read;
                if (this.read == FileData.this.length) {
                    this.remove();
                }
                return this.in.read();
            }
            return -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException, BadDataException {
            if (this.read >= FileData.this.length || this.closed) {
                return -1;
            }
            if (this.read + (long)n2 <= FileData.this.length) {
                while (this.in.available() == 0) {
                    if (FileData.this.incomplete) {
                        this.remove();
                        throw new BadDataException();
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException();
                    }
                }
                int n3 = this.in.read(byArray, n, n2);
                this.read += (long)n3;
                if (this.read == FileData.this.length) {
                    this.remove();
                }
                return n3;
            }
            return this.read(byArray, n, (int)(FileData.this.length - this.read));
        }

        public void close() throws IOException {
            if (this.closed) {
                throw new IOException();
            }
            this.closed = true;
            this.remove();
            this.in.close();
        }

        public void remove() {
            FileData.this.readers.removeElement(this);
        }
    }
}

