/*
 * Decompiled with CFR 0.152.
 */
package Freenet.node;

import Freenet.FieldSet;
import Freenet.node.DataProperties;
import Freenet.node.FileData;
import Freenet.support.io.ReadInputStream;
import Freenet.support.io.WriteOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileDataProperties
extends DataProperties {
    public static File path;
    public static String suffix;
    public static String descriptor;
    protected File name;
    protected long length;
    private String filename;
    protected boolean delFile = true;

    public static void main(String[] stringArray) throws Exception {
        FileDataProperties fileDataProperties = new FileDataProperties(new File(stringArray[0]));
        FieldSet fieldSet = ((DataProperties)fileDataProperties).restore();
        System.out.println(fieldSet.toString());
        FileDataProperties fileDataProperties2 = new FileDataProperties("lala");
        ((DataProperties)fileDataProperties2).store(fieldSet);
        System.out.println(((DataProperties)fileDataProperties2).restore().toString());
    }

    public FileDataProperties(FileData fileData) {
        this.filename = fileData.name.getName() + suffix;
    }

    public FileDataProperties(File file) {
        this.name = file;
        this.filename = file.getName();
        this.length = file.length();
    }

    public FileDataProperties(String string) {
        this.filename = string;
    }

    public void store(FieldSet fieldSet) throws IOException, DataProperties.WrongOrderException {
        if (this.name != null) {
            throw new DataProperties.WrongOrderException();
        }
        this.name = new File(path, this.filename);
        FileOutputStream fileOutputStream = new FileOutputStream(this.name);
        WriteOutputStream writeOutputStream = new WriteOutputStream(fileOutputStream);
        fieldSet.writeFields(writeOutputStream, descriptor, '\n', '=', '.');
        writeOutputStream.flush();
        this.length = this.name.length();
    }

    public FieldSet restore() throws IOException, DataProperties.WrongOrderException {
        if (this.name == null) {
            throw new DataProperties.WrongOrderException();
        }
        FileInputStream fileInputStream = new FileInputStream(this.name);
        ReadInputStream readInputStream = new ReadInputStream(fileInputStream);
        FieldSet fieldSet = new FieldSet();
        fieldSet.parseFields(readInputStream, '\n', '=', '.');
        return fieldSet;
    }

    public boolean isSaved() {
        return this.name != null;
    }

    public String toString() {
        if (this.name != null) {
            return this.name.toString();
        }
        return "(in RAM)";
    }

    public String fileName() {
        return this.name == null ? null : this.name.getPath();
    }

    public long length() {
        if (this.name != null) {
            return this.length;
        }
        return 0L;
    }

    public void delete() throws IOException {
        this.name.delete();
        this.name = null;
    }

    static {
        suffix = ".inf";
        descriptor = "Freenet properties file";
    }
}

