/*
 * Decompiled with CFR 0.152.
 */
package Freenet.node;

import Freenet.Key;
import Freenet.node.BadDataException;
import Freenet.node.Entity;
import Freenet.node.Node;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class StreamHandler {
    private Hashtable streams = new Hashtable();

    public StreamHandler(Node node) {
    }

    public void addStream(Key key, long l, Entity entity) {
        this.streams.put(key, new Container(entity, l));
    }

    public void addReader(Key key, long l) {
        Object v = this.streams.get(key);
        if (v != null && v instanceof Container) {
            ((Container)v).addReader(l);
        }
    }

    public void removeReader(Key key, long l) {
        Object v = this.streams.get(key);
        if (v != null && v instanceof Container) {
            Container container = (Container)v;
            container.removeReader(l);
            if (!container.hasReaders()) {
                this.streams.remove(key);
                try {
                    container.getEntity().data().stop();
                }
                catch (BadDataException badDataException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public Enumeration getReaders(Key key) {
        Object v = this.streams.get(key);
        return v != null && v instanceof Container ? ((Container)v).readers() : new EmptyEnumeration();
    }

    public Entity find(Key key) {
        Object v = this.streams.get(key);
        return v != null && v instanceof Container ? ((Container)v).getEntity() : null;
    }

    public Entity remove(Key key) {
        Object v = this.streams.remove(key);
        return v != null && v instanceof Container ? ((Container)v).getEntity() : null;
    }

    private class EmptyEnumeration
    implements Enumeration {
        private EmptyEnumeration() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() throws NoSuchElementException {
            throw new NoSuchElementException();
        }
    }

    private class Container {
        private Vector readers;
        private Entity e;

        public Container(Entity entity, long l) {
            this.e = entity;
            this.readers = new Vector(3);
            this.readers.addElement(new Long(l));
        }

        public Entity getEntity() {
            return this.e;
        }

        public void addReader(long l) {
            this.readers.addElement(new Long(l));
        }

        public void removeReader(long l) {
            this.readers.removeElement(new Long(l));
        }

        public boolean hasReaders() {
            return !this.readers.isEmpty();
        }

        public Enumeration readers() {
            return this.readers.elements();
        }
    }
}

