/*
 * Decompiled with CFR 0.152.
 */
package Freenet.node.gui;

import Freenet.Params;
import Freenet.node.gui.FProxySettings;
import Freenet.node.gui.Help;
import Freenet.node.gui.InformSettings;
import Freenet.node.gui.LoggingSettings;
import Freenet.node.gui.NetworkSettings;
import Freenet.node.gui.RoutingSettings;
import Freenet.node.gui.SettingsPanel;
import Freenet.node.gui.StoreSettings;
import Freenet.node.gui.TimingSettings;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Vector;

public class Config
extends Frame
implements ItemListener {
    protected Params params;
    protected SettingsPanel[] cards;
    protected Container cardPanel;
    protected CardLayout cardPanelLayout;
    protected List tabPanel;
    protected Component buttonPanel;
    protected Help help;
    protected String filename;
    static final Font tabFont = new Font("SanSerif", 0, 12);

    static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("usage: freenet_config <config file>");
            System.exit(1);
        }
        Config config = new Config(stringArray[0]){

            public void dispose() {
                super.dispose();
                System.exit(0);
            }
        };
        config.show();
    }

    public Config(String string) {
        this.filename = string;
        this.init(this.filename);
    }

    public Config() {
        String[] stringArray = Params.defaultRCFiles;
        this.filename = stringArray[0];
        int n = stringArray.length - 1;
        while (n > 0) {
            String string = stringArray[n];
            if (new File(string).exists()) {
                this.filename = string;
                break;
            }
            --n;
        }
        this.init(this.filename);
    }

    protected void init(String string) {
        this.setTitle("Freenet configurator 0.3");
        try {
            this.params = new Params(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.addComponents(this.params);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Config.this.actionCancel();
            }
        });
        ((Component)this).setSize(640, 400);
        this.validate();
    }

    protected void addComponents(Params params) {
        this.setLayout(new BorderLayout());
        this.help = new Help();
        this.cards = this.createCards(params, this.help);
        this.cardPanel = this.createCardPanel(this.cards);
        Panel panel = new Panel(new BorderLayout());
        panel.add((Component)this.cardPanel, "Center");
        panel.add((Component)this.help, "South");
        this.add((Component)panel, "Center");
        this.tabPanel = this.createTabs();
        this.add((Component)this.tabPanel, "West");
        this.buttonPanel = this.createButtonPanel();
        this.add(this.buttonPanel, "South");
    }

    protected SettingsPanel[] createCards(Params params, Help help) {
        Vector<SettingsPanel> vector = new Vector<SettingsPanel>();
        vector.addElement(new NetworkSettings(params, help));
        vector.addElement(new StoreSettings(params, help));
        vector.addElement(new InformSettings(params, help));
        vector.addElement(new RoutingSettings(params, help));
        vector.addElement(new TimingSettings(params, help));
        vector.addElement(new LoggingSettings(params, help));
        vector.addElement(new FProxySettings(params, help));
        return vector.toArray(new SettingsPanel[vector.size()]);
    }

    protected Panel createCardPanel(SettingsPanel[] settingsPanelArray) {
        this.cardPanelLayout = new CardLayout();
        Panel panel = new Panel(this.cardPanelLayout);
        int n = 0;
        while (n < settingsPanelArray.length) {
            panel.add((Component)settingsPanelArray[n], settingsPanelArray[n].getName());
            ++n;
        }
        return panel;
    }

    protected List createTabs() {
        List list = new List();
        list.setForeground(Color.blue);
        list.setFont(tabFont);
        int n = 0;
        while (n < this.cards.length) {
            list.add(this.cards[n].getName());
            ++n;
        }
        list.addItemListener(this);
        list.select(0);
        return list;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.showCard();
        }
    }

    protected void showCard() {
        this.cardPanelLayout.show(this.cardPanel, this.tabPanel.getSelectedItem());
    }

    protected Component createButtonPanel() {
        Button button = new Button("Ok");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Config.this.actionAccept();
            }
        });
        Button button2 = new Button("Cancel");
        button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Config.this.actionCancel();
            }
        });
        Panel panel = new Panel(new GridLayout(1, 2));
        panel.add(button);
        panel.add(button2);
        return panel;
    }

    protected boolean verify() {
        int n = 0;
        while (n < this.cards.length) {
            if (!this.cards[n].verify()) {
                this.tabPanel.select(n);
                this.showCard();
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void update() {
        int n = 0;
        while (n < this.cards.length) {
            this.cards[n].update();
            ++n;
        }
        this.params.writeParams(this.filename);
    }

    protected void actionCancel() {
        this.dispose();
    }

    protected void actionAccept() {
        if (!this.verify()) {
            return;
        }
        this.update();
        this.dispose();
    }
}

