/*
 * Decompiled with CFR 0.152.
 */
package Freenet.node.gui;

import Freenet.Core;
import Freenet.MessageObject;
import Freenet.node.DataStoreMaintence;
import Freenet.node.Node;
import Freenet.node.StandardDataStore;
import Freenet.node.gui.AboutDialog;
import Freenet.node.gui.Config;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class GUINode
extends Frame {
    private Label message;

    public static void main(String[] stringArray) {
        GUINode gUINode = new GUINode(stringArray);
    }

    public GUINode(String[] stringArray) {
        this.setLayout(new BorderLayout());
        this.setTitle("Freenet node 0.3");
        ((Component)this).setSize(250, 150);
        this.show();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GUINode.this.actionExit();
            }
        });
        MenuBar menuBar = this.createMenuBar();
        this.setMenuBar(menuBar);
        this.message = new Label("Node running");
        this.add((Component)this.message, "South");
        this.validate();
        Node.main(stringArray);
    }

    protected void actionConfigure() {
        Config config = new Config(){

            protected void actionAccept() {
                if (!this.verify()) {
                    return;
                }
                this.update();
                this.showDialog();
                this.dispose();
            }

            public void showDialog() {
                Dialog dialog = new Dialog((Frame)this, true);
                TextArea textArea = new TextArea("You must restart the node for the configuration to take effect.", 5, 30, 3);
                textArea.setEditable(false);
                dialog.add((Component)textArea, "Center");
                Button button = new Button("OK");
                2 var4_4 = this;
                button.addActionListener(new ActionListener(this, var4_4){
                    private final /* synthetic */ Window val$parent;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$parent = window;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$parent.hide();
                        this.this$1.dispose();
                    }
                });
                dialog.add((Component)button, "South");
                dialog.pack();
                Dimension dimension = dialog.getSize();
                Dimension dimension2 = this.getSize();
                Point point = this.getLocation();
                ((Component)dialog).setLocation(point.x + (dimension2.width - dimension.width) / 2, point.y + (dimension2.height - dimension.height) / 2);
                dialog.show();
            }
        };
        config.show();
    }

    protected void actionExit() {
        this.message.setText("Shutting down node");
        this.message.setForeground(Color.red);
        Node node = Node.n;
        try {
            if (node != null) {
                Object object;
                try {
                    object = node.threadManager;
                    if (object != null) {
                        object.flush();
                        object.halt();
                        ((Thread)object).join();
                    }
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Darn, interrupted!");
                }
                object = new DataStoreMaintence(Core.randSource.nextLong());
                node.mh.handle((MessageObject)object);
                if (node.ds instanceof StandardDataStore) {
                    ((DataStoreMaintence)object).cleardir((StandardDataStore)node.ds);
                }
            }
            Object var4_4 = null;
            this.dispose();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.dispose();
            System.exit(0);
            throw throwable;
        }
        System.exit(0);
    }

    protected void actionAbout() {
        AboutDialog aboutDialog = new AboutDialog(this);
        aboutDialog.show();
    }

    protected Menu createFileMenu() {
        Menu menu = new Menu("File");
        MenuItem menuItem = new MenuItem("Configure");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUINode.this.actionConfigure();
            }
        });
        menu.add(menuItem);
        MenuItem menuItem2 = new MenuItem("Exit");
        menuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUINode.this.actionExit();
            }
        });
        menu.add(menuItem2);
        return menu;
    }

    protected Menu createHelpMenu() {
        Menu menu = new Menu("Help");
        MenuItem menuItem = new MenuItem("About");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUINode.this.actionAbout();
            }
        });
        menu.add(menuItem);
        return menu;
    }

    protected MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createHelpMenu());
        return menuBar;
    }
}

