/*
 * Decompiled with CFR 0.152.
 */
package Freenet.presentation;

import Freenet.Address;
import Freenet.Connection;
import Freenet.Core;
import Freenet.FieldSet;
import Freenet.InvalidMessageException;
import Freenet.Presentation;
import Freenet.RawMessage;
import Freenet.crypt.CipherLink;
import Freenet.crypt.DiffieHellman;
import Freenet.crypt.Global;
import Freenet.crypt.ciphers.Rijndael;
import Freenet.presentation.FNPRawMessage;
import Freenet.support.Logger;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;

public class FreenetProtocol
extends Presentation {
    private DiffieHellman kE;

    public FreenetProtocol() {
        this(false);
    }

    public FreenetProtocol(boolean bl) {
        this.kE = new DiffieHellman(Global.DHgroupA, Core.randSource, bl ? 0 : 5);
    }

    public void initConnection(Connection connection) throws IOException {
        Rijndael rijndael = new Rijndael(128, 128);
        int n = connection.getSoTimeout();
        connection.setSoTimeout(Core.authTimeout);
        try {
            try {
                CipherLink cipherLink = new CipherLink(Core.randSource, this.kE, rijndael, connection.in, connection.out);
                connection.info = cipherLink;
                connection.setReady();
            }
            catch (InterruptedIOException interruptedIOException) {
                Core.logger.log(this, "Authentication timed out", Logger.ERROR);
                connection.close();
                throw interruptedIOException;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            connection.setSoTimeout(n);
            throw throwable;
        }
        connection.setSoTimeout(n);
    }

    public InputStream getReceiveStream(Connection connection) throws IOException {
        if (connection.ready()) {
            return ((CipherLink)connection.info).getInputStream();
        }
        Object object = connection.initLock;
        synchronized (object) {
            try {
                connection.initLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.getReceiveStream(connection);
    }

    public OutputStream getSendStream(Connection connection) throws IOException {
        if (connection.ready()) {
            return ((CipherLink)connection.info).getOutputStream();
        }
        Object object = connection.initLock;
        synchronized (object) {
            try {
                connection.initLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.getSendStream(connection);
    }

    public RawMessage readMessage(InputStream inputStream) throws InvalidMessageException, EOFException {
        int n;
        PushbackInputStream pushbackInputStream = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream);
        do {
            try {
                n = pushbackInputStream.read();
            }
            catch (IOException iOException) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
                throw new InvalidMessageException("Error while waiting for message");
            }
        } while (n == 0);
        if (n == -1) {
            throw new EOFException();
        }
        try {
            pushbackInputStream.unread(n);
        }
        catch (IOException iOException) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                iOException3.printStackTrace();
            }
            throw new RuntimeException("Problem while pushing back read data in FreenetProtocol");
        }
        return new FNPRawMessage(pushbackInputStream);
    }

    public RawMessage newMessage(String string, Address address, boolean bl, FieldSet fieldSet, long l, String string2, InputStream inputStream) {
        return new FNPRawMessage(string, address, bl, fieldSet, l, string2, inputStream);
    }
}

