/*
 * Decompiled with CFR 0.152.
 */
package Freenet.scripts;

import Freenet.Params;
import Freenet.scripts.ServerPortSearch;
import Freenet.support.Logger;
import Freenet.support.StandardLogger;
import Freenet.support.io.ReadInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Date;

public class Setup {
    public static PrintStream out;
    public static PrintStream qout;
    public static ReadInputStream in;
    public static boolean expert;
    public static Params params;
    static /* synthetic */ Class class$Freenet$scripts$Setup;

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length > 0) {
            try {
                params = new Params(stringArray[0]);
            }
            catch (FileNotFoundException fileNotFoundException) {
                bl = true;
            }
            try {
                out = new PrintStream(new FileOutputStream(stringArray[0]));
                if (bl) {
                    params = new Params(stringArray[0]);
                }
            }
            catch (IOException iOException) {
                System.out.println("Could not open file for writing");
                System.exit(1);
            }
        } else {
            System.out.println("Usage: Freenet.scripts.setup outfile [simple|expert]");
            System.exit(1);
        }
        in = new ReadInputStream(System.in);
        qout = System.out;
        qout.println("Freenet Configuration");
        expert = stringArray.length == 1 ? Setup.getBool("Create Freenet ini file in expert mode (asks about everything)?", false) : stringArray[1].equalsIgnoreCase("expert");
        if (!expert) {
            qout.println("Running in simple mode. Some preferences will be skipped.");
        }
        qout.println("You can choose the default preferences by just hitting <ENTER>");
        out.println("[Freenet node]");
        out.println("# Freenet configuration file");
        out.println("# Note that all properties may be overridden from the command line,");
        out.println("# so for example, java Freenet.Node -listenPort 10000 will cause");
        out.println("# the setting in this file to be ignored");
        out.println();
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        out.println("# This file was automatically generated by Freenet setup (at " + dateFormat.format(new Date()) + ")");
        out.println();
        out.println();
        qout.println();
        Method[] methodArray = (class$Freenet$scripts$Setup == null ? (class$Freenet$scripts$Setup = Setup.class$("Freenet.scripts.Setup")) : class$Freenet$scripts$Setup).getMethods();
        Setup.quickSort(methodArray, 0, methodArray.length - 1);
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().startsWith("setParam")) {
                try {
                    if (expert) {
                        qout.println("Setting: " + methodArray[n].getName().substring(8));
                    }
                    methodArray[n].invoke(null, null);
                    out.println();
                    qout.println();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                }
            }
            ++n;
        }
        qout.println("Setup finished, exiting.");
    }

    private static void quickSort(Method[] methodArray, int n, int n2) {
        if (n2 - n < 1) {
            return;
        }
        Method method = methodArray[n];
        int n3 = n;
        int n4 = n2;
        boolean bl = true;
        Method method2 = methodArray[n4];
        while (n3 < n4) {
            int n5 = method.getName().compareTo(method2.getName());
            if (bl) {
                if (n5 > 0) {
                    methodArray[n3] = method2;
                    method2 = methodArray[n3 + 1];
                    ++n3;
                    bl = false;
                    continue;
                }
                method2 = methodArray[--n4];
                continue;
            }
            if (n5 < 0) {
                methodArray[n4] = method2;
                method2 = methodArray[n4 - 1];
                --n4;
                bl = true;
                continue;
            }
            method2 = methodArray[++n3];
        }
        methodArray[n3] = method;
        Setup.quickSort(methodArray, n, n3 - 1);
        Setup.quickSort(methodArray, n3 + 1, n2);
    }

    public static void clearInput() throws IOException {
        while (in.available() > 0) {
            in.read();
        }
    }

    public static void qeof() {
        qout.println("Input interrupted");
        System.exit(1);
    }

    public static void comment(String string) {
        out.println("# " + string);
        qout.println(string);
    }

    public static void expComment(String string) {
        out.println("# " + string);
        if (expert) {
            qout.println(string);
        }
    }

    public static boolean getBool(String string, boolean bl) {
        try {
            int n;
            qout.print(string + " ");
            do {
                qout.println(bl ? "[Y/n]" : " [y/N]");
                n = in.read();
                if (n >= 0) continue;
                Setup.qeof();
            } while (n != 121 && n != 89 && n != 110 && n != 78 && n != 13 && n != 10);
            Setup.clearInput();
            return n == 13 || n == 10 ? bl : n == 121 || n == 89;
        }
        catch (IOException iOException) {
            Setup.qeof();
            return false;
        }
    }

    public static String getString(String string, String string2) {
        try {
            qout.println(string + " [" + string2 + ']');
            String string3 = in.readTo('\n', '\r');
            Setup.clearInput();
            return "".equals(string3) ? string2 : string3;
        }
        catch (IOException iOException) {
            Setup.qeof();
            return null;
        }
    }

    public static long getNumber(String string, long l) {
        boolean bl;
        long l2 = 0L;
        do {
            bl = false;
            String string2 = Setup.getString(string, Long.toString(l));
            try {
                l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
        } while (bl);
        return l2;
    }

    public static void setParamListenPort() {
        String string = "listenPort";
        Setup.comment("The port to which the Freenet Server should listen for connections");
        qout.println("Setup will attempt to find a free port that Freenet can use");
        ServerPortSearch serverPortSearch = new ServerPortSearch();
        boolean bl = false;
        int n = params.getint(string, 19114);
        if (n != 19114) {
            qout.println("You have already another port (" + n + ") than the default configured.");
            bl = Setup.getBool("Do you want to keep it?", true);
        }
        while (!bl) {
            int n2;
            qout.println("Searching...");
            bl = false;
            n = serverPortSearch.getFreePort();
            bl = Setup.getBool("Port " + n + " is free. Should we use it?", true);
            if (bl || !Setup.getBool("Input port manually?", false)) continue;
            do {
                n2 = (int)Setup.getNumber("Port value to use?", n);
            } while (n < 0 || n > 65536);
            n = n2;
            bl = true;
        }
        out.println(string + "=" + n);
    }

    public static void setParamTransient() {
        String string = "transient";
        Setup.expComment("Transient nodes will not send their address to other nodes, and therefore");
        Setup.expComment("will not get any requests for data (except if you activate the \"inform\" CGI");
        Setup.expComment("service below). Use this only if you are on a slow, non permanent connection.");
        qout.println();
        boolean bl = params.getboolean(string, false);
        if (expert) {
            bl = Setup.getBool("Should your node be transient?", bl);
        }
        out.println(string + "=" + (bl ? "yes" : "no"));
    }

    public static void setParamCheckPointInterval() {
        String string = "checkPointInterval";
        long l = params.getlong(string, 300L);
        Setup.expComment("How often to write the datastore to disk (in seconds)");
        if (expert) {
            l = Setup.getNumber("?", l);
        }
        out.println(string + "=" + l);
    }

    public static void setParamNodeAddress() {
        String string = "nodeAddress";
        Setup.comment("The address to use when advertising this node to  the network. If this is ");
        Setup.comment("unset, which is prefered, the node's address will be read from the socket,");
        Setup.comment("allowing the node to function seamlessly on multihomed machines (and even");
        Setup.comment("functioning a Freenet proxy over firewalls where necessary). However, people");
        Setup.comment("who have volatile IP addresses but constant DNS names (such as people using");
        Setup.comment("Dynamic DNS services) may wish to set this so their node can still be found");
        Setup.comment("after the ip changes.");
        qout.println();
        String string2 = Setup.getString("Enter the node address, or press enter to let the node autodetect.\n", params.getParam(string, ""));
        out.println((string2.equals("") ? "#" : "") + string + "=" + string2);
    }

    public static void setParamDataStoreSettings() {
        String string = "diskCache";
        String string2 = "dataStoreSize";
        String string3 = "dataStorePath";
        out.println("# The size of the disk cache is specified here in bytes");
        long l = params.getlong(string, 100000000L);
        l = Setup.getNumber("How much diskspace, in Megabytes, can Freenet use?", l / 0x100000L);
        out.println(string + "=" + l * 0x100000L);
        out.println("");
        Setup.expComment("The number of items permitted in the dataStore");
        long l2 = params.getlong(string2, 500L);
        if (expert) {
            l2 = Setup.getNumber("How many?", l2);
        }
        out.println(string2 + "=" + l2);
        Setup.expComment("The name of the directory containing the dataStore (store_port) file");
        String string4 = params.getParam(string3, ".freenet");
        if (expert) {
            string4 = Setup.getString("Directory name (relative)?", string4);
        }
        out.println(string3 + "=" + string4);
    }

    public static void setParamDataPath() {
        String string = "dataPath";
        Setup.expComment("The name of the directory containing the data files");
        String string2 = params.getParam(string, ".freenet");
        if (expert) {
            string2 = Setup.getString("Directory name (relative)?", string2);
        }
        out.println(string + "=" + string2);
    }

    public static void setParamDataPropertiesPath() {
        String string = "dataPropertiesPath";
        Setup.expComment("The name of the directory containing the data properties files");
        String string2 = params.getParam(string, ".freenet");
        if (expert) {
            string2 = Setup.getString("Directory name (relative)?", string2);
        }
        out.println(string + "=" + string2);
    }

    public static void setParamMessageStoreSize() {
        String string = "messageStoreSize";
        Setup.expComment("The number of outstanding message replies the node will");
        Setup.expComment("wait for before it starts to \"forget\" them");
        long l = params.getlong(string, 500L);
        if (expert) {
            l = Setup.getNumber("?", l);
        }
        out.println(string + "=" + l);
    }

    public static void setParamNodeFile() {
        String string = "nodeFile";
        Setup.expComment("The name of a file containing an initial set of nodes to connect to");
        String string2 = params.getParam(string, "nodes.config");
        if (expert) {
            string2 = Setup.getString("File name?", string2);
        }
        out.println(string + "=" + string2);
    }

    public static void setParamInform() {
        String string = "informRead";
        Setup.expComment("Should we read some information about other nodes from the informUrl?");
        boolean bl = params.getboolean(string, true);
        if (expert) {
            Setup.getBool("?", bl);
        }
        out.println(string + "=" + (bl ? "yes" : "no"));
        string = "informWrite";
        Setup.expComment("Should we write our address to the inform URL so that others might");
        Setup.expComment("find out about us more easily?");
        boolean bl2 = params.getboolean(string, true);
        if (expert) {
            bl2 = Setup.getBool("?", bl2);
        }
        out.println(string + "=" + (bl2 ? "yes" : "no"));
        string = "informDelay";
        Setup.expComment("After which time (seconds) of node uptime should we add the presence to the informURL?");
        long l = params.getlong(string, 86400L);
        if (expert) {
            l = Setup.getNumber("?", l);
        }
        out.println(string + "=" + l);
        Setup.expComment("The URL of a CGI script which will allow the server");
        Setup.expComment("to learn about other servers in the Freenet, and");
        Setup.expComment("to inform other servers of its presence.");
        string = "informUrl";
        String string2 = params.getParam(string, "http://www.octayne.com/inform.php");
        if (expert) {
            string2 = Setup.getString("Full URL?", string2);
        }
        out.println(string + "=" + string2);
    }

    public static void setParamBandWidthLimit() {
        String string = "bandwidthLimit";
        Setup.comment("The maximum rate to transmit data, measure in bytes per second.");
        out.println("# If set unset bandwidth usage will not be limited.");
        qout.println("Enter 0 to disable bandwidth limiting");
        long l = params.getlong(string, 50000L);
        l = Setup.getNumber("?", l);
        out.println((l == 0L ? "# " : "") + string + "=" + l);
    }

    public static void setParamTickerTime() {
        String string = "tickerTime";
        Setup.expComment("The number of milliseconds between ticks on the timer");
        long l = params.getlong(string, 500L);
        if (expert) {
            l = Setup.getNumber("?", l);
        }
        out.println(string + "=" + l);
    }

    public static void setParamHopsTimes() {
        String string = "hopTimeExpected";
        String string2 = "hopTimeDeviation";
        Setup.expComment("The expected time and standard deviation, in milliseconds, that it takes");
        Setup.expComment("a Freenet node to pass a message. These are used to calculate how long");
        Setup.expComment("the node should wait before assuming that a passed message is lost.");
        Setup.expComment("These are mostly here for debugging reasons - changing them will NOT");
        Setup.expComment("make requests come back faster for you.");
        long l = params.getlong(string, 12000L);
        long l2 = params.getlong(string2, 12000L);
        if (expert) {
            l = Setup.getNumber("Expected value?", l);
            l2 = Setup.getNumber("Standard Deviation?", l2);
        }
        out.println(string + "=" + l);
        out.println(string2 + "=" + l2);
    }

    public static void setParamConnectTimeout() {
        String string = "connectTimeout";
        Setup.expComment("How long to wait to connect to a host before giving up (in milliseconds)");
        long l = params.getlong(string, 30000L);
        if (expert) {
            l = Setup.getNumber("?", l);
        }
        out.println(string + "=" + l);
    }

    public static void setParamConnectionTimeout() {
        String string = "connectionTimeout";
        Setup.expComment("How long to wait listen on an inactive connection before closing (if");
        Setup.expComment("reply address is known).");
        long l = params.getlong(string, 180000L);
        if (expert) {
            l = Setup.getNumber("?", l);
        }
        out.println(string + "=" + l);
    }

    public static void setParamDoHandshake() {
        String string = "doHandshake";
        Setup.expComment("Leave this as \"yes\" unless you are doing timeout debugging.");
        boolean bl = true;
        if (expert) {
            bl = Setup.getBool("Should we handshake other nodes?", bl);
        }
        out.println(string + "=" + (bl ? "yes" : "no"));
    }

    public static void setParamAuthTimeout() {
        String string = "authTimeout";
        Setup.expComment("How long to wait for a handshake (in milliseconds)");
        long l = params.getlong(string, 30000L);
        if (expert) {
            l = Setup.getNumber("?", l);
        }
        out.println(string + "=" + l);
    }

    public static void setParamHandshakeTimeout() {
        String string = "handshakeTimeout";
        Setup.expComment("How long to wait for a handshake (in milliseconds)");
        long l = params.getlong(string, 30000L);
        if (expert) {
            l = Setup.getNumber("?", l);
        }
        out.println(string + "=" + l);
    }

    public static void setParamHandshakeLife() {
        String string = "handshakeLife";
        Setup.expComment("How long before a handshake expires (in milliseconds)");
        long l = params.getlong(string, 10000000L);
        if (expert) {
            l = Setup.getNumber("?", l);
        }
        out.println(string + "=" + l);
    }

    public static void setParamMaximumConnectionThreads() {
        String string = "maximumConnectionThreads";
        Setup.expComment("Should we use thread-management?  If this number is defined and non-zero,");
        Setup.expComment("this specifies how many inbound connections can be active at once.");
        long l = params.getlong(string, 50L);
        if (expert) {
            l = Setup.getNumber("?", l);
        }
        out.println(string + "=" + l);
    }

    public static void setParamMaxHopsToLive() {
        String string = "maxHopsToLive";
        Setup.expComment("The maximum number of hops to live to tolerate on Requests the node");
        Setup.expComment("passes. This does not directly effect your node, only the total load");
        Setup.expComment("on the network, so there is no reason to change it.");
        long l = params.getlong(string, 100L);
        if (expert) {
            l = Setup.getNumber("?", l);
        }
        out.println(string + "=" + l);
    }

    public static void setParamKeyTypes() {
        out.println("# A list of keytype number class pairs for plugin keytypes");
        out.println("#keyTypes=");
    }

    public static void setParamLogging() {
        int[] nArray = new int[]{Logger.ERROR, Logger.NORMAL, Logger.MINOR, Logger.DEBUGGING};
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            StringBuffer stringBuffer = new StringBuffer(StandardLogger.priorityOf(nArray[n]));
            while (stringBuffer.length() < 16) {
                stringBuffer.append(' ');
            }
            stringArray[n] = stringBuffer.toString();
            ++n;
        }
        Setup.expComment("The error reporting threshold, one of:");
        if (expert) {
            qout.print("0");
        }
        Setup.expComment("  " + stringArray[0] + "Errors only");
        if (expert) {
            qout.print("1");
        }
        Setup.expComment("  " + stringArray[1] + "Report significant events");
        if (expert) {
            qout.print("2");
        }
        Setup.expComment("  " + stringArray[2] + "Report minor events");
        if (expert) {
            qout.print("3");
        }
        Setup.expComment("  " + stringArray[3] + "Report events only of relevance when debugging");
        long l = 1L;
        if (expert) {
            while ((l = Setup.getNumber("What level should we use?", 1L)) < 0L || l >= (long)stringArray.length) {
            }
        }
        out.println("logging=" + stringArray[(int)l]);
    }

    public static void setParamLogFile() {
        String string = "logFile";
        Setup.expComment("The name of the log file ( \"no\" to log to screen (standard out))");
        String string2 = params.getParam(string, "freenet.log");
        if (expert) {
            Setup.getString("?", string2);
        }
        out.println(string + "=" + string2);
    }

    public static void setParamVerbosity() {
        String string = "verbosity";
        Setup.expComment("How verbose should the logging be? (1-5)");
        long l = params.getlong(string, 4L);
        if (expert) {
            while ((l = Setup.getNumber("?", l)) < 1L || l > 5L) {
            }
        }
        out.println(string + "=" + l);
    }

    public static void setParamBufferSize() {
        String string = "bufferSize";
        Setup.expComment("What size should the buffers have when moving data?");
        long l = params.getlong(string, 4096L);
        if (expert) {
            l = Setup.getNumber("?", l);
        }
        out.println(string + "=" + l);
    }

    public static void setParamFProxy() {
        String string = "services.fproxy.class";
        String string2 = "Freenet.contrib.fproxy.HttpHandlerServlet";
        String string3 = "services.fproxy.port";
        String string4 = "services.fproxy.config";
        String string5 = ".fproxyrc";
        out.println("# Set to Freenet.contrib.fproxy.HttpHandlerServlet to start FProxy automatically with the node");
        boolean bl = Setup.getBool("Should FProxy automatically be started with the node?", true);
        String string6 = bl ? (expert ? Setup.getString("Location of FProxy ?", string2) : string2) : "";
        out.println(string + "=" + string6);
        long l = params.getlong(string3, 8081L);
        if (expert) {
            l = Setup.getNumber("FProxy port to use?", l);
        }
        out.println(string3 + "=" + l);
        String string7 = params.getParam(string4, string5);
        if (expert) {
            string7 = Setup.getString("FProxy config file?", string7);
        }
        out.println(string4 + "=" + string7);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        expert = false;
    }
}

