/*
 * Decompiled with CFR 0.152.
 */
package Freenet.support;

import Freenet.Core;
import Freenet.crypt.BlockCipher;
import Freenet.crypt.CipherInputStream;
import Freenet.crypt.CipherOutputStream;
import Freenet.crypt.Util;
import Freenet.support.FileBucket;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CryptBucket
extends FileBucket {
    private byte[] key;
    private String cipher;
    private BlockCipher encrypt;

    public CryptBucket(File file, String string) {
        super(file);
        this.cipher = string;
        BlockCipher blockCipher = Util.getCipherByName(string);
        if (blockCipher == null) {
            throw new IllegalArgumentException();
        }
        this.key = new byte[blockCipher.getKeySize() >> 3];
        Core.randSource.nextBytes(this.key);
    }

    public CryptBucket(String string) {
        this.cipher = string;
        BlockCipher blockCipher = Util.getCipherByName(string);
        if (blockCipher == null) {
            throw new IllegalArgumentException();
        }
        this.key = new byte[blockCipher.getKeySize() >> 3];
        Core.randSource.nextBytes(this.key);
    }

    public OutputStream getOutputStream() throws IOException {
        boolean bl = this.restart;
        if (bl) {
            this.encrypt = Util.getCipherByName(this.cipher);
            this.encrypt.initialize(this.key);
        }
        CipherOutputStream cipherOutputStream = new CipherOutputStream(this.encrypt, super.getOutputStream());
        if (bl) {
            byte[] byArray = new byte[this.encrypt.getBlockSize() >> 3];
            byte[] byArray2 = new byte[this.encrypt.getBlockSize() >> 3];
            System.arraycopy(this.key, 0, byArray2, 0, byArray2.length);
            Util.makeKey(byArray2, byArray, 0, byArray.length);
            cipherOutputStream.write(this.key);
        }
        return cipherOutputStream;
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = super.getInputStream();
        if (inputStream == null) {
            return null;
        }
        BlockCipher blockCipher = Util.getCipherByName(this.cipher);
        blockCipher.initialize(this.key);
        return new CipherInputStream(blockCipher, inputStream);
    }

    public long size() {
        return this.encrypt == null ? 0L : super.size() - (long)(this.encrypt.getBlockSize() >> 3);
    }
}

