/*
 * Decompiled with CFR 0.152.
 */
package Freenet.support;

import Freenet.Core;
import Freenet.support.Bucket;
import Freenet.support.Fields;
import Freenet.support.Logger;
import Freenet.support.OnExitCleanUp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileBucket
implements Bucket {
    protected File file;
    protected boolean restart = true;
    protected boolean newFile;
    protected static String tempDir;

    public FileBucket(File file) {
        this.file = file;
        this.newFile = false;
    }

    public FileBucket() {
        this.file = new File(tempDir, "t" + Fields.longToString(Math.abs(Core.randSource.nextInt())));
        this.newFile = true;
        OnExitCleanUp.deleteOnExit(this.file);
    }

    public OutputStream getOutputStream() throws IOException {
        boolean bl = !this.restart;
        this.restart = false;
        return new FileOutputStream(this.file.getPath(), bl);
    }

    public InputStream getInputStream() throws IOException {
        return this.file.exists() ? new FileInputStream(this.file) : null;
    }

    public void resetWrite() {
        this.restart = true;
    }

    public long size() {
        return this.file.length();
    }

    public File getFile() {
        return this.file;
    }

    public void finalize() throws Throwable {
        if (this.newFile && this.file.exists()) {
            Core.logger.log(this, "Deleting bucket " + this.file.getName(), Logger.DEBUGGING);
            if (!this.file.delete()) {
                Core.logger.log(this, "Delete failed on bucket " + this.file.getName(), Logger.MINOR);
            }
        }
    }

    static {
        String string;
        tempDir = null;
        tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir == null && (string = System.getProperty("os.name")) != null) {
            String[] stringArray;
            String[] stringArray2 = null;
            if (string.equalsIgnoreCase("Linux")) {
                stringArray2 = stringArray = new String[]{"/tmp", "/var/tmp"};
            } else if (string.equalsIgnoreCase("Windows")) {
                stringArray2 = stringArray = new String[]{"C:\\TEMP", "C:\\WINDOWS\\TEMP"};
            }
            if (stringArray2 != null) {
                int n = 0;
                while (n < stringArray2.length) {
                    File file = new File(stringArray2[n]);
                    if (file.exists() && file.isDirectory() && file.canWrite()) {
                        tempDir = stringArray2[n];
                        break;
                    }
                    ++n;
                }
            }
        }
        if (tempDir == null) {
            tempDir = System.getProperty("user.dir");
        }
    }
}

