/*
 * Decompiled with CFR 0.152.
 */
package Freenet.support;

import Freenet.Core;
import Freenet.support.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class PriorityHashtable
implements Serializable {
    int size = 0;
    int maxSize;
    Object[] array;
    Hashtable refs;
    Hashtable data;

    public static void main(String[] stringArray) throws IOException {
        PriorityHashtable priorityHashtable = new PriorityHashtable(10);
        priorityHashtable.put("a", new Hashtable());
        priorityHashtable.print();
        System.out.println(priorityHashtable.get("a"));
    }

    public PriorityHashtable(int n) {
        this.maxSize = n;
        this.array = new Object[n];
        this.refs = new Hashtable(n);
        this.data = new Hashtable(n);
    }

    public int length() {
        return this.size;
    }

    public void put(Object object, Object object2) {
        Core.logger.log(this, "adding " + object + ":" + object2 + " (" + this.size + "/" + (this.maxSize - 1) + ")", Logger.DEBUGGING);
        Object v = this.data.get(object);
        if (v != null) {
            return;
        }
        this.trim();
        this.array[this.size] = object;
        this.data.put(object, object2);
        Integer n = new Integer(this.size);
        this.refs.put(object, n);
        ++this.size;
    }

    public Object get(Object object) {
        return this.data.get(object);
    }

    public void promote(Object object) {
        System.out.println("promoting " + object);
        Integer n = (Integer)this.refs.get(object);
        System.out.println("ref is " + n);
        if (n == null) {
            return;
        }
        int n2 = n;
        if (n2 == 0) {
            return;
        }
        if (this.array[n2] != null && this.array[n2 - 1] != null) {
            this.refs.remove(this.array[n2]);
            this.refs.remove(this.array[n2 - 1]);
            Object object2 = this.array[n2 - 1];
            this.array[n2 - 1] = this.array[n2];
            this.array[n2] = object2;
            this.refs.put(this.array[n2], new Integer(n2));
            this.refs.put(this.array[n2 - 1], new Integer(n2 - 1));
        }
    }

    public void trim() {
        if (this.size < this.maxSize) {
            return;
        }
        Object object = this.array[this.maxSize - 1];
        this.data.remove(object);
        this.refs.remove(object);
        --this.size;
    }

    public void print() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            System.out.println(e + " - " + this.data.get(e));
        }
    }

    public Enumeration elements() {
        return new PriorityEnumeration();
    }

    private class PriorityEnumeration
    implements Enumeration {
        int i = 0;

        public boolean hasMoreElements() {
            return this.i <= PriorityHashtable.this.size - 1;
        }

        public Object nextElement() {
            return PriorityHashtable.this.array[this.i++];
        }
    }
}

