/*
 * Decompiled with CFR 0.152.
 */
package Freenet.support.io;

import Freenet.Core;
import Freenet.support.Logger;
import Freenet.support.io.ControlInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PadOnErrorInputStream
extends FilterInputStream {
    protected ControlInputStream parent;

    public PadOnErrorInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public void setCIS(ControlInputStream controlInputStream) {
        this.parent = controlInputStream;
    }

    public int read() throws IOException {
        try {
            int n = this.in.read();
            if (n == -1) {
                this.goPadding(new EOFException());
                return this.read();
            }
            return n;
        }
        catch (IOException iOException) {
            this.goPadding(iOException);
            return this.read();
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 == -1) {
                this.goPadding(new EOFException());
                return this.read(byArray, n, n2);
            }
            return n3;
        }
        catch (Exception exception) {
            this.goPadding(exception);
            return this.read(byArray, n, n2);
        }
    }

    protected void goPadding(Exception exception) throws IOException {
        Core.logger.log(this, "Exception caught: " + exception + " padding...", Logger.NORMAL);
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.in = new ZeroInputStream();
        if (this.parent != null) {
            this.parent.endWithNextControl(1);
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }

    class ZeroInputStream
    extends InputStream {
        protected boolean closed = false;

        ZeroInputStream() {
        }

        public int read() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            return 0;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            int n3 = n;
            while (n3 < n + n2) {
                byArray[n3] = 0;
                ++n3;
            }
            return n2;
        }

        public int available() {
            return 32768;
        }
    }
}

