/*
 * Decompiled with CFR 0.152.
 */
package Freenet.support.io;

import Freenet.Core;
import Freenet.support.Logger;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ThrottledOutputStream
extends FilterOutputStream {
    private static final int ticksPerSecond = 10;
    private static final int millisPerTick = 100;
    private static int bandwidthPerTick = 0;
    private static int available;
    private static long moreBandwidthTime;

    private ThrottledOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(int n) throws IOException {
        ThrottledOutputStream.getBandwidth(1);
        this.out.write(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = ThrottledOutputStream.getBandwidth(n2);
            this.out.write(byArray, n, n3);
            n2 -= n3;
            n += n3;
        }
    }

    protected static synchronized int getBandwidth(int n) {
        ThrottledOutputStream.waitForBandwidth();
        int n2 = Math.min(n, available);
        available -= n2;
        return n2;
    }

    protected static synchronized void waitForBandwidth() {
        while (true) {
            long l = System.currentTimeMillis();
            ThrottledOutputStream.refillAvailableBandwidth(l);
            if (available != 0) break;
            try {
                Thread.currentThread();
                Thread.sleep(moreBandwidthTime - l);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected static synchronized void refillAvailableBandwidth(long l) {
        if (l >= moreBandwidthTime) {
            available = bandwidthPerTick;
            moreBandwidthTime = l + 100L;
        }
    }

    public static void setThrottle(int n) {
        bandwidthPerTick = n / 10;
    }

    public static OutputStream throttledStream(OutputStream outputStream) {
        if (bandwidthPerTick <= 0) {
            return outputStream;
        }
        Core.logger.log(null, "ThrottledOutput, creating new stream, bpt = " + bandwidthPerTick, Logger.DEBUG);
        return new ThrottledOutputStream(outputStream);
    }
}

