/*
 * Decompiled with CFR 0.152.
 */
package Freenet.support.io;

import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class TimeoutInputStream
extends FilterInputStream {
    private int read;
    private volatile boolean available;
    private int timeOut = 0;
    private IOException readException = null;
    private ReadThread rt;

    public static void main(String[] stringArray) throws Exception {
        TimeoutInputStream timeoutInputStream = new TimeoutInputStream(new FileInputStream(stringArray[0]));
        int n = 0;
        do {
            n = timeoutInputStream.read();
            System.out.print((char)n);
        } while (n != -1);
    }

    public TimeoutInputStream(InputStream inputStream) {
        super(inputStream);
        this.rt = new ReadThread(inputStream);
        this.rt.start();
    }

    public synchronized int read() throws IOException {
        while (true) {
            if (this.available) {
                if (this.readException != null) {
                    IOException iOException = this.readException;
                    this.readException = null;
                    this.available = false;
                    this.rt.interrupt();
                    throw iOException;
                }
                int n = this.read;
                if (n != -1) {
                    this.available = false;
                    this.rt.interrupt();
                }
                return n;
            }
            try {
                this.wait(this.timeOut);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
    }

    public void setTimeout(int n) {
        this.timeOut = n;
    }

    private class ReadThread
    extends Thread {
        private InputStream in;

        public ReadThread(InputStream inputStream) {
            super("InputStream reading thread for TimeoutInputStream");
            this.in = inputStream;
        }

        public void run() {
            while (true) {
                if (!TimeoutInputStream.this.available) {
                    IOException iOException = null;
                    int n = -2;
                    try {
                        n = this.in.read();
                    }
                    catch (IOException iOException2) {
                        iOException = iOException2;
                    }
                    TimeoutInputStream timeoutInputStream = TimeoutInputStream.this;
                    synchronized (timeoutInputStream) {
                        if (iOException != null) {
                            TimeoutInputStream.this.readException = iOException;
                        } else {
                            TimeoutInputStream.this.read = n;
                        }
                        TimeoutInputStream.this.available = true;
                        TimeoutInputStream.this.notify();
                        if (n == -1) {
                            break;
                        }
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

