/*
 * Decompiled with CFR 0.152.
 */
package Freenet.support.io;

import Freenet.support.io.DataNotValidIOException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class VerifyingInputStream
extends FilterInputStream {
    protected long dataLength;
    protected long bytesRead;
    protected boolean finished = false;
    protected boolean stripControls = false;
    protected boolean allRead = false;

    public VerifyingInputStream(InputStream inputStream, long l) {
        super(inputStream);
        this.dataLength = l;
    }

    public void stripControls(boolean bl) {
        this.stripControls = bl;
    }

    public int read() throws IOException, DataNotValidIOException {
        return this.priv_read();
    }

    private int priv_read() throws IOException, DataNotValidIOException {
        int n = super.read();
        if (n != -1) {
            ++this.bytesRead;
        }
        if (!this.finished && this.bytesRead >= this.dataLength) {
            this.finished = true;
        } else if (!this.finished && this.stripControls && this.bytesRead == this.dataLength - 1L) {
            System.err.println("ALL READ");
            this.allRead = true;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException, DataNotValidIOException {
        return this.priv_read(byArray, n, n2);
    }

    private int priv_read(byte[] byArray, int n, int n2) throws IOException, DataNotValidIOException {
        int n3;
        if (this.finished) {
            return -1;
        }
        if (this.bytesRead == this.dataLength - 1L) {
            int n4 = this.priv_read();
            if (n4 == -1) {
                return -1;
            }
            byArray[n] = (byte)n4;
            n3 = 1;
        } else {
            if (!this.finished && (long)n2 > this.dataLength - 1L - this.bytesRead) {
                n2 = (int)(this.dataLength - 1L - this.bytesRead);
            }
            if ((n3 = super.read(byArray, n, n2)) != -1) {
                this.bytesRead += (long)n3;
            }
            if (this.stripControls && this.bytesRead == this.dataLength - 1L) {
                this.allRead = true;
            }
        }
        return n3;
    }

    public int available() throws IOException {
        int n = super.available();
        return (long)n + this.bytesRead >= this.dataLength ? (this.stripControls ? (int)(this.dataLength - this.bytesRead - 1L) : (int)(this.dataLength - this.bytesRead)) : n;
    }
}

