/*
 * Decompiled with CFR 0.152.
 */
package Freenet.transport;

import Freenet.BadAddressException;
import Freenet.ProtocolAddress;
import Freenet.ProtocolListeningAddress;
import Freenet.transport.tcpListeningAddress;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class tcpAddress
extends ProtocolAddress {
    public String hostName;
    public InetAddress host;
    public int port;

    public tcpAddress(InetAddress inetAddress, int n) throws IllegalArgumentException {
        this.host = inetAddress;
        this.setPort(n);
    }

    public tcpAddress(String string, int n) throws IllegalArgumentException, BadAddressException {
        try {
            this.hostName = string;
            this.host = InetAddress.getByName(string);
            this.setPort(n);
        }
        catch (UnknownHostException unknownHostException) {
            throw new BadAddressException();
        }
    }

    public tcpAddress(String string) throws IllegalArgumentException, BadAddressException {
        try {
            int n = string.indexOf(58);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            this.hostName = string.substring(0, n);
            this.host = InetAddress.getByName(this.hostName);
            this.setPort(new Integer(string.substring(n + 1)));
        }
        catch (UnknownHostException unknownHostException) {
            throw new BadAddressException();
        }
    }

    public ProtocolListeningAddress listenPart() {
        return new tcpListeningAddress(this.port);
    }

    public String toString() {
        String string = this.hostName == null ? this.host.getHostAddress() : this.hostName;
        return string + ":" + this.port;
    }

    public boolean equals(Object object) {
        return object instanceof tcpAddress && ((tcpAddress)object).host.equals(this.host) && ((tcpAddress)object).port == this.port;
    }

    public boolean equalsHost(Object object) {
        return object instanceof tcpAddress && ((tcpAddress)object).host.equals(this.host);
    }

    public void setPort(int n) throws IllegalArgumentException {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException();
        }
        this.port = n;
    }
}

