/*
 * Decompiled with CFR 0.152.
 */
package Freenet;

import Freenet.Address;
import Freenet.ConnectFailedException;
import Freenet.ConnectionHandler;
import Freenet.Core;
import Freenet.HandshakeHandler;
import Freenet.SendFailedException;
import Freenet.message.HandshakeRequest;
import Freenet.support.Logger;
import java.util.Date;
import java.util.Hashtable;

public class StandardHandshakeHandler
implements HandshakeHandler {
    private volatile Hashtable handshakes = new Hashtable();
    private Hashtable waiters = new Hashtable();

    public boolean getHandshake(Core core, ConnectionHandler connectionHandler) {
        long l;
        Date date = (Date)this.handshakes.get(connectionHandler.peer());
        if (date != null) {
            if (date.getTime() + (long)Core.handshakeLife < new Date().getTime()) {
                this.handshakes.remove(connectionHandler.peer());
                date = null;
            } else {
                return true;
            }
        }
        while ((l = Math.abs(Core.randSource.nextLong())) <= 65536L) {
        }
        HandshakeRequest handshakeRequest = new HandshakeRequest(l);
        Waiter waiter = new Waiter(connectionHandler.peer());
        Long l2 = new Long(handshakeRequest.id);
        Waiter waiter2 = waiter;
        synchronized (waiter2) {
            try {
                this.waiters.put(l2, waiter);
                handshakeRequest.sending(core, connectionHandler);
                connectionHandler.sendMessage(handshakeRequest);
            }
            catch (SendFailedException sendFailedException) {
                Core.logger.log(this, "Couldn't send handshake request", Logger.MINOR);
                boolean bl = false;
                return bl;
            }
            try {
                waiter.wait(Core.handshakeTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.waiters.remove(l2);
        }
        date = (Date)this.handshakes.get(waiter.addr);
        Core.logger.log(this, "Done waiting for handshake, returning " + (date != null), Logger.DEBUG);
        return date != null;
    }

    public boolean getHandshake(Core core, Address address) {
        Date date = (Date)this.handshakes.get(address);
        if (date != null) {
            if (date.getTime() + (long)Core.handshakeLife < new Date().getTime()) {
                this.handshakes.remove(address);
                date = null;
            } else {
                return true;
            }
        }
        try {
            ConnectionHandler connectionHandler = core.connect(address);
            return this.getHandshake(core, connectionHandler);
        }
        catch (ConnectFailedException connectFailedException) {
            return false;
        }
    }

    public void setHandshake(long l) {
        try {
            Waiter waiter = (Waiter)this.waiters.get(new Long(l));
            this.handshakes.put(waiter.addr, new Date());
            Waiter waiter2 = waiter;
            synchronized (waiter2) {
                waiter.notifyAll();
            }
        }
        catch (ClassCastException classCastException) {
            Core.logger.log(this, "Something is putting bad objects in the waiter table", Logger.ERROR);
        }
        catch (NullPointerException nullPointerException) {
            Core.logger.log(this, "Got unexpected HandshakeReply", Logger.DEBUGGING);
        }
    }

    public void failHandshake(long l) {
        try {
            Waiter waiter;
            Waiter waiter2 = waiter = (Waiter)this.waiters.get(new Long(l));
            synchronized (waiter2) {
                waiter.notifyAll();
            }
        }
        catch (ClassCastException classCastException) {
            Core.logger.log(this, "Something is putting bad objects in the waiter table", Logger.ERROR);
        }
        catch (NullPointerException nullPointerException) {
            Core.logger.log(this, "Got unexpected (bad) HandshakeReply", Logger.DEBUGGING);
        }
    }

    private class Waiter {
        public Address addr;

        public Waiter(Address address) {
            this.addr = address;
        }
    }
}

