/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.Address;
import Freenet.BadAddressException;
import Freenet.Params;
import Freenet.client.ClientCore;
import Freenet.client.ClientUtil;
import Freenet.crypt.BlockCipher;
import Freenet.crypt.CipherInputStream;
import Freenet.crypt.Util;
import Freenet.support.Bucket;
import Freenet.support.CryptBucket;
import Freenet.support.Fields;
import Freenet.support.FileBucket;
import Freenet.support.Logger;
import Freenet.support.OnExitCleanUp;
import Freenet.support.StandardLogger;
import Freenet.support.io.ReadInputStream;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.BindException;

public class CLI {
    public static boolean library = false;
    protected static final int defaultListenPort = 0;
    protected static final String defaultServerAddress = "tcp/127.0.0.1:19114";
    protected static final long defaultHopsToLive = 10L;
    protected static final String defaultLogging = "NORMAL";
    protected static final int defaultVerbosity = StandardLogger.SPARSE;
    protected static final String defaultCipherName = "Twofish";
    public static int exitState = 0;
    protected ClientCore cc;
    protected Address target;
    protected String cipherName;
    protected long htl;
    protected boolean safer;
    static /* synthetic */ Class class$Freenet$client$CLI;

    public CLI(Params params) throws IllegalArgumentException {
        this(params, null, false);
    }

    public CLI(Params params, Logger logger) throws IllegalArgumentException {
        this(params, logger, false);
    }

    public CLI(Params params, Logger logger, boolean bl) throws IllegalArgumentException {
        if (logger == null) {
            String string = params.getParam("logging", defaultLogging);
            int n = StandardLogger.priorityOf(string);
            int n2 = params.getint("verbosity", defaultVerbosity);
            logger = new StandardLogger(System.err, n2, n);
        }
        if (params.getParam("jump", "no").equalsIgnoreCase("yes")) {
            CLI.jump();
        }
        if (params.getParam("version", "no").equalsIgnoreCase("yes")) {
            CLI.version();
        }
        int n = params.getint("listenPort", 0);
        String string = params.getParam("serverAddress", defaultServerAddress);
        this.htl = params.getlong("htl", 10L);
        this.cipherName = params.getParam("cipher", defaultCipherName);
        this.safer = !params.getParam("safer", "no").equalsIgnoreCase("no");
        try {
            this.cc = bl ? ClientUtil.getServiceCore(n) : ClientUtil.getTCPCore(n, params, logger);
            this.target = ClientUtil.getAddress(string);
        }
        catch (BadAddressException badAddressException) {
            throw new IllegalArgumentException("Could not parse address `" + string + "'.  It should be " + "<host>:<port> or tcp/<host>:<port>");
        }
        catch (BindException bindException) {
            throw new IllegalArgumentException("Could not bind to port " + n + ".  (Remember, users " + "only have access to ports >1024 on most systems.)");
        }
    }

    public void printOptions(PrintStream printStream) {
        printStream.println("");
        printStream.println("  -length bytes              Bytes to insert (if reading stdin)");
        printStream.println("  -metadata file             Attach private metadata to the document");
        printStream.println("  -cipher cipher-name        Use 'cipher-name' as the cipher");
        printStream.println("                             Choices are 'Twofish' (default) or 'Rijndael'");
        printStream.println("  -listenPort port           Local port to listen for replies on");
        printStream.println("  -safer yes|no              Avoid unnecessary risk by encrypting all data");
        printStream.println("                             written to disk. Slow and not perfect. Default off.");
        printStream.println("  -serverAddress address     Server node to connect to");
        printStream.println("  -htl hops-to-live          Hops-to-live for request");
        printStream.println("  -logging error|normal      Logging level");
        printStream.println("           |minor|debugging");
        printStream.println("  -verbosity 0-5             Verbosity of log messages");
    }

    public Bucket getBucket() {
        if (this.safer) {
            return new CryptBucket(this.cipherName);
        }
        return new FileBucket();
    }

    public static void waitForThreadsAndExit() {
        int n;
        do {
            Thread[] threadArray = new Thread[Thread.activeCount()];
            n = 0;
            int n2 = Thread.enumerate(threadArray);
            int n3 = 0;
            while (n3 < n2) {
                if (!threadArray[n3].isDaemon()) {
                    ++n;
                }
                ++n3;
            }
            if (n <= true) continue;
            Thread.currentThread();
            Thread.yield();
        } while (n > true);
        OnExitCleanUp.doCleanUp();
        if (!library) {
            System.exit(exitState);
        }
    }

    public static void version() {
        System.out.println();
        System.out.println("                 Freenet Reference Client");
        System.out.println();
        int n = Math.max("0.3".length(), "1.299".length());
        StringBuffer stringBuffer = new StringBuffer("1.299");
        while (stringBuffer.length() < 16) {
            stringBuffer.append(' ');
        }
        String string = stringBuffer.toString();
        stringBuffer = new StringBuffer("0.3");
        while (stringBuffer.length() < 16) {
            stringBuffer.append(' ');
        }
        String string2 = stringBuffer.toString();
        System.out.println("Freenet Version:   " + string2 + "Client Version:    " + "0.3");
        System.out.println("Protocol Version:  " + string + "Build Number:      " + "161");
        System.exit(0);
    }

    public static void jump() {
        try {
            InputStream inputStream = (class$Freenet$client$CLI == null ? (class$Freenet$client$CLI = CLI.class$("Freenet.client.CLI")) : class$Freenet$client$CLI).getResourceAsStream("dataThing");
            if (inputStream == null) {
                return;
            }
            ReadInputStream readInputStream = new ReadInputStream(new BufferedInputStream(inputStream));
            HexInputStream hexInputStream = new HexInputStream(readInputStream);
            BlockCipher blockCipher = Util.getCipherByName(defaultCipherName);
            blockCipher.initialize(new byte[]{97, 98, -8, -75, 2, -60, 10, -52, 46, -2, 61, -68, 108, -91, 127, -33});
            CipherInputStream cipherInputStream = new CipherInputStream(blockCipher, hexInputStream);
            try {
                while (true) {
                    System.out.print((char)cipherInputStream.read());
                }
            }
            catch (EOFException eOFException) {
                System.exit(0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class HexInputStream
    extends InputStream {
        ReadInputStream rin;
        int c = 0;

        public HexInputStream(ReadInputStream readInputStream) {
            this.rin = readInputStream;
        }

        public int read() throws IOException {
            String string = this.rin.readTo(' ');
            ++this.c;
            return (int)Fields.stringToLong(string);
        }
    }
}

