/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.Address;
import Freenet.ConnectFailedException;
import Freenet.ConnectionHandler;
import Freenet.Core;
import Freenet.FieldSet;
import Freenet.Key;
import Freenet.KeyException;
import Freenet.Message;
import Freenet.SendFailedException;
import Freenet.client.ClientCore;
import Freenet.client.ClientEvent;
import Freenet.client.ClientEventListener;
import Freenet.client.ClientEventProducer;
import Freenet.client.ClientKey;
import Freenet.client.ClientMessageObject;
import Freenet.client.Document;
import Freenet.client.EventInputStream;
import Freenet.client.RequestToken;
import Freenet.client.SimpleEventProducer;
import Freenet.client.events.CollisionEvent;
import Freenet.client.events.ErrorEvent;
import Freenet.client.events.ExceptionEvent;
import Freenet.client.events.NoReplyEvent;
import Freenet.client.events.ReceiveEvent;
import Freenet.client.events.RequestCompleteEvent;
import Freenet.client.events.RequestFailedEvent;
import Freenet.client.events.RestartedEvent;
import Freenet.client.events.SegmentCompleteEvent;
import Freenet.client.events.SendEvent;
import Freenet.client.events.StateReachedEvent;
import Freenet.client.events.TransferStartedEvent;
import Freenet.crypt.BlockCipher;
import Freenet.crypt.Util;
import Freenet.message.DataInsert;
import Freenet.message.DataReply;
import Freenet.message.DataRequest;
import Freenet.message.InsertReply;
import Freenet.message.InsertRequest;
import Freenet.message.QueryRestarted;
import Freenet.message.RequestFailed;
import Freenet.message.RequestRestarted;
import Freenet.message.StoreData;
import Freenet.message.TimedOut;
import Freenet.support.Bucket;
import Freenet.support.io.DataNotValidIOException;
import Freenet.support.io.VerifyingInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Client {
    public static final String clientVersion = "0.3";
    public static final int INIT = 0;
    public static final int PREPARED = 1;
    public static final int REQUESTING = 2;
    public static final int TRANSFERING = 3;
    public static final int DONE = 4;
    public static final int FAILED = -1;
    protected ClientCore core;
    protected Address target;

    public static String stateOf(int n) {
        return n == 0 ? "INIT" : (n == 1 ? "PREPARED" : (n == 2 ? "REQUESTING" : (n == 3 ? "TRANSFERING" : (n == 4 ? "DONE" : "FAILED"))));
    }

    public Client(ClientCore clientCore, Address address) {
        this.core = clientCore;
        this.target = address;
    }

    public RequestToken prepare(long l, InputStream inputStream, long l2, InputStream inputStream2, long l3, ClientKey clientKey, String string, Bucket bucket) throws IOException {
        BInsertInstance bInsertInstance = new BInsertInstance(l, inputStream, l2, inputStream2, l3, clientKey, string, bucket);
        new Thread((Runnable)bInsertInstance, "Insert: " + clientKey.toString()).start();
        return bInsertInstance;
    }

    public RequestToken prepare(long l, ClientKey clientKey, Bucket bucket, Bucket bucket2) {
        BRequestInstance bRequestInstance = new BRequestInstance(l, clientKey, bucket, bucket2);
        new Thread((Runnable)bRequestInstance, "Request: " + clientKey.toString()).start();
        return bRequestInstance;
    }

    public void makeRequest(RequestToken requestToken) {
        if (requestToken instanceof BInstance) {
            ((BInstance)requestToken).execute();
        }
    }

    protected File tempFile() {
        File file = new File(Util.intToHexString(Core.randSource.nextInt()) + ".tmp");
        return file;
    }

    protected class BInsertInstance
    extends BInstance {
        private Document doc;
        private FieldSet storables;
        private InputStream processedInput;
        private InputStream sourceData;
        private InputStream sourceMetadata;
        private long mdatalen;
        private long datalen;
        private Bucket ctBucket;

        public BInsertInstance(long l, InputStream inputStream, long l2, InputStream inputStream2, long l3, ClientKey clientKey, String string, Bucket bucket) throws KeyException {
            super(l, clientKey);
            this.cipherName = string;
            this.ckey = clientKey;
            this.storables = new FieldSet();
            this.storables.add("Symmetric-cipher", string);
            this.storables.add("Metadata-length", l3 + "");
            this.sourceData = inputStream;
            this.datalen = l2;
            this.sourceMetadata = inputStream2;
            this.mdatalen = l3;
            this.ctBucket = bucket;
        }

        protected synchronized void prepare() throws Exception {
            BlockCipher blockCipher = Util.getCipherByName(this.cipherName);
            this.doc = new Document(this.sourceData, this.sourceMetadata, this.ckey.getEncryptionKey(blockCipher.getKeySize() >> 3), this.datalen, this.mdatalen);
            this.processedInput = new EventInputStream(this.ckey.docToStream(this.doc, blockCipher, this.ctBucket), this.ckey.getDataLength() / 20L);
            ((ClientEventProducer)((Object)this.processedInput)).addEventListener(this);
            this.key = this.ckey.getKey(this.storables);
            super.prepare();
        }

        protected synchronized void doit() {
            try {
                InsertRequest insertRequest = new InsertRequest(this.id, this.htl, this.initDepth, this.key);
                this.sendMessage(insertRequest);
                this.state(2);
                ClientMessageObject clientMessageObject = this.getQueryResponse(this.id, RequestRestarted.getTime(this.htl) + (long)(Core.hopTimeExpected * 2));
                if (clientMessageObject instanceof Message && ((Message)clientMessageObject).receivedWith != this.current) {
                    if (this.current != null && this.current.isOpen()) {
                        this.current.close();
                    }
                    this.current = ((Message)clientMessageObject).receivedWith;
                }
                if (clientMessageObject instanceof InsertReply) {
                    ClientMessageObject clientMessageObject2;
                    FieldSet fieldSet = new FieldSet();
                    fieldSet.add("Storable", this.storables);
                    DataInsert dataInsert = new DataInsert(this.id, this.htl, this.initDepth, fieldSet, this.processedInput);
                    dataInsert.length = this.ckey.getDataLength();
                    SentInsert sentInsert = new SentInsert();
                    this.state(3);
                    this.sendMessage(dataInsert, sentInsert);
                    this.produceEvent(new TransferStartedEvent(dataInsert.length));
                    while ((clientMessageObject2 = this.getNextReply(this.id, 0L)) != sentInsert) {
                    }
                    if (sentInsert.isSuccess()) {
                        StoreData storeData = new StoreData(this.id, this.htl, this.initDepth, null);
                        try {
                            this.sendMessage(storeData);
                            this.state(4);
                        }
                        catch (SendFailedException sendFailedException) {
                            this.produceEvent(new ExceptionEvent(sendFailedException));
                            this.state(-1);
                        }
                    } else {
                        this.produceEvent(new ExceptionEvent(sentInsert.getException()));
                        this.state(-1);
                    }
                    try {
                        this.processedInput.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    if (this.current != null) {
                        this.current.forceClose();
                    }
                    if (clientMessageObject instanceof DataReply || clientMessageObject instanceof TimedOut) {
                        this.produceEvent(new CollisionEvent(this.ckey));
                    } else if (clientMessageObject instanceof RequestFailed) {
                        this.produceEvent(new RequestFailedEvent(this.ckey, (Message)clientMessageObject));
                    } else {
                        this.produceEvent(new NoReplyEvent());
                    }
                    this.state(-1);
                }
            }
            catch (Exception exception) {
                this.produceEvent(new ExceptionEvent(exception));
                if (this.current != null) {
                    this.current.forceClose();
                }
                this.state(-1);
            }
        }

        private class SentInsert
        implements ClientMessageObject {
            Exception e;

            private SentInsert() {
            }

            public long id() {
                return BInsertInstance.this.id;
            }

            public void setException(Exception exception) {
                this.e = exception;
            }

            public Exception getException() {
                return this.e;
            }

            public boolean isSuccess() {
                return this.e == null;
            }
        }
    }

    protected class BRequestInstance
    extends BInstance {
        private VerifyingInputStream vin;
        private FieldSet storables;
        private Bucket data;
        private Bucket metaData;

        public BRequestInstance(long l, ClientKey clientKey, Bucket bucket, Bucket bucket2) {
            super(l, clientKey);
            this.data = bucket;
            this.metaData = bucket2;
        }

        public void prepare() throws Exception {
            Key key;
            this.key = key = this.ckey.getKey();
            super.prepare();
        }

        public void doit() {
            try {
                this.state(2);
                DataRequest dataRequest = new DataRequest(this.id, this.htl, this.initDepth, this.key);
                this.sendMessage(dataRequest);
                this.getResponse();
                if (this.state() != -1) {
                    ClientMessageObject clientMessageObject = this.getNextReply(this.id, 5000L);
                    if (!(clientMessageObject instanceof StoreData)) {
                        throw new Exception("Unexpected message: " + clientMessageObject);
                    }
                    this.state(4);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (this.current != null) {
                    this.current.forceClose();
                }
                this.produceEvent(new ExceptionEvent(exception));
                this.state(-1);
            }
        }

        public void getResponse() throws Exception {
            ClientMessageObject clientMessageObject = this.getQueryResponse(this.id, RequestRestarted.getTime(this.htl) + (long)(Core.hopTimeExpected * 2));
            if (clientMessageObject instanceof DataReply) {
                Object object;
                DataReply dataReply = (DataReply)clientMessageObject;
                this.storables = dataReply.otherFields.isSet("Storable") ? dataReply.otherFields.getSet("Storable") : new FieldSet();
                InputStream inputStream = dataReply.in;
                this.vin = this.key.verifyStream(dataReply.in, this.storables, dataReply.length);
                this.vin.stripControls(true);
                this.cipherName = this.storables.get("Symmetric-cipher") == null ? "Twofish" : this.storables.get("Symmetric-cipher");
                BlockCipher blockCipher = Util.getCipherByName(this.cipherName);
                byte[] byArray = this.ckey.getEncryptionKey(blockCipher.getKeySize() >> 3);
                String string = this.storables.get("Metadata-length");
                long l = string == null ? 0L : Long.parseLong(string);
                this.state(3);
                long l2 = this.ckey.getPlainLength(dataReply.length, this.storables);
                try {
                    object = Document.read(this.vin, byArray, blockCipher, l2 - 2L - (long)byArray.length - l, l);
                    this.beginTransfer((Document)object, this.storables);
                }
                catch (DataNotValidIOException dataNotValidIOException) {
                    dataNotValidIOException.printStackTrace();
                    int n = dataNotValidIOException.getCode();
                    InputStream inputStream2 = inputStream;
                    synchronized (inputStream2) {
                        inputStream.notify();
                    }
                    if (n == 1) {
                        this.state(2);
                        this.getResponse();
                        return;
                    }
                    throw dataNotValidIOException;
                }
                object = inputStream;
                synchronized (object) {
                    inputStream.notify();
                }
                this.produceEvent(new RequestCompleteEvent(null));
            } else {
                this.state(-1);
                if (this.current != null) {
                    this.current.forceClose();
                }
                if (clientMessageObject == null) {
                    this.produceEvent(new NoReplyEvent());
                } else if (clientMessageObject instanceof Message) {
                    this.produceEvent(new RequestFailedEvent(this.ckey, (Message)clientMessageObject));
                } else {
                    this.produceEvent(new ErrorEvent("Got an unexpected internal MessageObject: " + clientMessageObject));
                }
            }
        }

        public void beginTransfer(Document document, FieldSet fieldSet) throws IOException, DataNotValidIOException {
            long[] lArray = new long[]{document.metadataLength(), document.dataLength(), document.length()};
            this.produceEvent(new TransferStartedEvent(lArray));
            EventInputStream eventInputStream = new EventInputStream(document.data, document.length() / 20L);
            eventInputStream.addEventListener(this);
            BufferedOutputStream[] bufferedOutputStreamArray = new BufferedOutputStream[2];
            try {
                if (document.metadataLength() > 0L) {
                    bufferedOutputStreamArray[1] = new BufferedOutputStream(this.metaData.getOutputStream());
                    this.readData(eventInputStream, bufferedOutputStreamArray[1], document.metadataLength());
                }
                this.produceEvent(new SegmentCompleteEvent(this.metaData));
                bufferedOutputStreamArray[0] = new BufferedOutputStream(this.data.getOutputStream());
                this.readData(eventInputStream, bufferedOutputStreamArray[0], document.dataLength());
                this.produceEvent(new SegmentCompleteEvent(this.data));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.data.resetWrite();
                this.metaData.resetWrite();
                throw iOException;
            }
        }

        protected void readData(InputStream inputStream, OutputStream outputStream, long l) throws IOException, DataNotValidIOException {
            byte[] byArray = new byte[Core.bufferSize];
            int n = 0;
            do {
                if ((n = inputStream.read(byArray, 0, (int)Math.min(l, (long)byArray.length))) <= 0) continue;
                l -= (long)n;
                outputStream.write(byArray, 0, n);
            } while (n != -1 && l != 0L);
            outputStream.flush();
            outputStream.close();
        }
    }

    protected abstract class BInstance
    extends SimpleEventProducer
    implements RequestToken,
    Runnable,
    ClientEventListener {
        private int state = 0;
        private boolean ready = false;
        protected ConnectionHandler current;
        protected long htl;
        protected long id;
        protected long initDepth;
        protected Key key;
        protected ClientKey ckey;
        protected String cipherName;

        protected BInstance(long l, ClientKey clientKey) {
            this.htl = l;
            this.ckey = clientKey;
        }

        public void state(int n) {
            if (n >= -1 && n <= 4) {
                this.state = n;
            }
            this.produceEvent(new StateReachedEvent(n));
        }

        public int state() {
            return this.state;
        }

        protected void sendMessage(Message message) throws SendFailedException {
            this.sendMessage(message, null);
        }

        protected void sendMessage(Message message, ClientMessageObject clientMessageObject) throws SendFailedException {
            try {
                if (this.current == null || !this.current.isOpen()) {
                    this.current = Client.this.core.makeConnection(Client.this.target);
                }
                message.sending(Client.this.core, this.current);
                this.current.sendMessage(message, clientMessageObject);
            }
            catch (ConnectFailedException connectFailedException) {
                throw new SendFailedException(Client.this.target);
            }
            this.produceEvent(new SendEvent(Client.this.target, message, ""));
        }

        protected ClientMessageObject getNextReply(long l, long l2) throws InterruptedException {
            ClientMessageObject clientMessageObject = Client.this.core.cmh.getNextReply(l, l2);
            this.produceEvent(new ReceiveEvent(clientMessageObject instanceof Message ? Client.this.target : null, clientMessageObject, ""));
            return clientMessageObject;
        }

        protected ClientMessageObject getQueryResponse(long l, long l2) {
            ClientMessageObject clientMessageObject;
            try {
                boolean bl;
                do {
                    if (!(bl = (clientMessageObject = this.getNextReply(l, l2)) != null && clientMessageObject instanceof QueryRestarted)) continue;
                    this.produceEvent(new RestartedEvent(l2));
                } while (clientMessageObject != null && bl);
            }
            catch (InterruptedException interruptedException) {
                clientMessageObject = null;
            }
            return clientMessageObject;
        }

        protected synchronized void prepare() throws Exception {
            do {
                this.id = Math.abs(Core.randSource.nextLong());
            } while (this.id <= 65536L);
            this.initDepth = Core.randSource.nextInt() & 0x24;
            this.current = Client.this.core.makeConnection(Client.this.target);
            this.state(1);
            while (!this.ready) {
                this.wait();
            }
            this.doit();
        }

        public final synchronized void execute() {
            this.ready = true;
            if (this.state == 1) {
                this.notify();
            }
        }

        protected abstract void doit();

        public final void run() {
            try {
                this.prepare();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.produceEvent(new ExceptionEvent(exception));
                BInstance bInstance = this;
                synchronized (bInstance) {
                    this.state(-1);
                    this.notifyAll();
                }
            }
        }

        public void receive(ClientEvent clientEvent) {
            this.produceEvent(clientEvent);
        }
    }
}

