/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.FieldSet;
import Freenet.Key;
import Freenet.KeyException;
import Freenet.client.Base64;
import Freenet.client.ClientKey;
import Freenet.client.Document;
import Freenet.client.FreenetURI;
import Freenet.crypt.BlockCipher;
import Freenet.crypt.DSAKeyPair;
import Freenet.crypt.DigestOutputStream;
import Freenet.crypt.SHA1;
import Freenet.crypt.Util;
import Freenet.crypt.Yarrow;
import Freenet.keys.SVK;
import Freenet.support.Bucket;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.Random;

public class ClientSVK
implements ClientKey {
    protected long dataLen;
    protected InputStream dis;
    protected Random r;
    protected FreenetURI keyData;
    protected DSAKeyPair kp;
    protected byte[] contentHash;
    protected SVK key;

    protected ClientSVK() throws KeyException {
    }

    public ClientSVK(FreenetURI freenetURI) throws KeyException {
        if (!freenetURI.getKeyType().equals("SVK")) {
            throw new KeyException("URI is not an SVK");
        }
        this.key = new SVK(freenetURI.getKeyVal());
    }

    public ClientSVK(Random random) throws KeyException {
        this(random, null);
    }

    public ClientSVK(Random random, String string) throws KeyException {
        this(random, string, null);
    }

    public ClientSVK(Random random, String string, DSAKeyPair dSAKeyPair) throws KeyException {
        this.kp = dSAKeyPair;
        this.r = random;
        this.keyData = new FreenetURI("SVK", string, null, null);
    }

    public byte[] getEncryptionKey(int n) throws KeyException {
        if (this.keyData.getCryptoKey() == null) {
            byte[] byArray = new byte[n];
            this.r.nextBytes(byArray);
            byte[] byArray2 = new byte[n];
            Util.makeKey(byArray, byArray2, 0, byArray2.length);
            this.keyData = new FreenetURI(this.keyData.getKeyType(), this.keyData.getGuessableKey(), this.keyData.getKeyVal(), byArray2);
        }
        return this.keyData.getCryptoKey();
    }

    public InputStream docToStream(Document document, BlockCipher blockCipher, Bucket bucket) throws IOException {
        Object object;
        SHA1 sHA1 = new SHA1();
        if (!this.keyData.getKeyType().equals("KSK") && this.keyData.getGuessableKey() != null) {
            object = Util.hashString(new SHA1(), this.keyData.getGuessableKey());
            sHA1.update((byte[])object, 0, ((Object)object).length);
        }
        object = new DigestOutputStream(sHA1, bucket.getOutputStream());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
        document.write(bufferedOutputStream, blockCipher);
        ((OutputStream)bufferedOutputStream).close();
        this.contentHash = ((DigestOutputStream)object).getDigest().digest();
        this.dis = new SequenceInputStream(new BufferedInputStream(bucket.getInputStream()), new ByteArrayInputStream(new byte[]{0}));
        this.dataLen = document.length() + 1L;
        return this.dis;
    }

    public Key getKey() {
        if (this.key != null) {
            return this.key;
        }
        if (this.kp != null) {
            this.key = SVK.makeSVK(this.kp, this.keyData.getGuessableKey(), null);
        } else {
            this.key = SVK.makeSVK(this.r, this.keyData.getGuessableKey(), null);
            this.kp = this.key.getKeyPair();
        }
        this.keyData = new FreenetURI(this.keyData.getKeyType(), this.keyData.getGuessableKey(), this.key.getVal(), this.keyData.getCryptoKey());
        return this.key;
    }

    public Key getKey(FieldSet fieldSet) {
        if (this.kp != null) {
            this.key = SVK.makeSVK(this.kp, this.keyData.getGuessableKey(), fieldSet);
        } else {
            this.key = SVK.makeSVK(this.r, this.keyData.getGuessableKey(), fieldSet);
            this.kp = this.key.getKeyPair();
        }
        this.key.sign(this.contentHash, this.r, fieldSet);
        this.keyData = new FreenetURI(this.keyData.getKeyType(), this.keyData.getGuessableKey(), this.key.getVal(), this.keyData.getCryptoKey());
        return this.key;
    }

    public byte[] getPrivateKey() {
        return this.key == null ? null : this.key.getKeyPair().getX().toByteArray();
    }

    public String getPrivateKeyString() {
        return this.key == null ? null : Base64.encode(this.getPrivateKey());
    }

    public long getDataLength() {
        return this.dataLen;
    }

    public long getPlainLength(long l, FieldSet fieldSet) {
        return l - 1L;
    }

    public FreenetURI getURI() {
        return this.keyData;
    }

    public static void main(String[] stringArray) throws Exception {
        ClientSVK clientSVK = new ClientSVK(new Yarrow());
        clientSVK.getKey();
        clientSVK.getEncryptionKey(16);
        System.err.println(clientSVK.getURI());
        FreenetURI freenetURI = new FreenetURI(clientSVK.getURI().toString());
        freenetURI.decompose();
    }

    public String toString() {
        return this.key == null ? "new SVK" : this.getURI().toString();
    }
}

