/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.Address;
import Freenet.BadAddressException;
import Freenet.Core;
import Freenet.KeyException;
import Freenet.ListenException;
import Freenet.ListeningAddress;
import Freenet.Params;
import Freenet.client.ClientCore;
import Freenet.client.ClientKey;
import Freenet.client.FreenetURI;
import Freenet.presentation.FreenetProtocol;
import Freenet.support.FileBucket;
import Freenet.support.Loader;
import Freenet.support.Logger;
import Freenet.support.SuppressedLogger;
import Freenet.support.io.WriteOutputStream;
import Freenet.transport.tcpAddress;
import Freenet.transport.tcpListeningAddress;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.MalformedURLException;

public abstract class ClientUtil {
    static /* synthetic */ Class class$Freenet$client$FreenetURI;

    public static ClientCore getTCPCore(int n) throws BindException {
        return ClientUtil.getTCPCore(n, new Params(), new SuppressedLogger());
    }

    public static ClientCore getTCPCore(int n, Params params, Logger logger) throws BindException {
        try {
            params.setParam("transient", "yes");
            Core.setLogger(logger);
            Core.init(params);
            ClientCore clientCore = new ClientCore(new ListeningAddress("tcp", new tcpListeningAddress(n)), new FreenetProtocol(true));
            clientCore.acceptConnections();
            return clientCore;
        }
        catch (ListenException listenException) {
            throw new BindException("Error binding to port " + n);
        }
    }

    public static ClientCore getServiceCore(int n) throws BindException {
        try {
            ClientCore clientCore = new ClientCore(new ListeningAddress("tcp", new tcpListeningAddress(n)), new FreenetProtocol());
            clientCore.acceptConnections();
            return clientCore;
        }
        catch (ListenException listenException) {
            throw new BindException("Error binding to port " + n);
        }
    }

    public static Address getAddress(InetAddress inetAddress, int n) throws IllegalArgumentException {
        return new Address("tcp", new tcpAddress(inetAddress, n));
    }

    public static Address getAddress(String string, int n) throws IllegalArgumentException, BadAddressException {
        return new Address("tcp", new tcpAddress(string, n));
    }

    public static Address getAddress(String string) throws IllegalArgumentException, BadAddressException {
        if (string.indexOf(47) == -1) {
            string = "tcp/" + string;
        }
        return new Address(string);
    }

    public static ClientKey getKey(String string) throws MalformedURLException, KeyException {
        FreenetURI freenetURI = new FreenetURI(string);
        return ClientUtil.getKeyFromURI(freenetURI);
    }

    public static ClientKey getKeyFromURI(FreenetURI freenetURI) {
        try {
            return (ClientKey)Loader.getInstance("Freenet.client.Client" + freenetURI.getKeyType(), new Class[]{class$Freenet$client$FreenetURI == null ? (class$Freenet$client$FreenetURI = ClientUtil.class$("Freenet.client.FreenetURI")) : class$Freenet$client$FreenetURI}, new Object[]{freenetURI});
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            if (invocationTargetException.getTargetException() instanceof KeyException) {
                throw (KeyException)invocationTargetException.getTargetException();
            }
            throw new KeyException(invocationTargetException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(classNotFoundException);
            throw new KeyException("Unknown keytype");
        }
        catch (ClassCastException classCastException) {
            throw new KeyException("Class found, but didn't contain Key");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new KeyException("Key not constructable from URI");
        }
        catch (InstantiationException instantiationException) {
            throw new KeyException("Something went wrong");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new KeyException("Illegal access");
        }
    }

    protected static FileBucket makeRedirectBucket(FreenetURI freenetURI) throws IOException {
        FileBucket fileBucket = new FileBucket();
        WriteOutputStream writeOutputStream = new WriteOutputStream(new FileOutputStream(fileBucket.getFile()));
        writeOutputStream.println("Redirect");
        writeOutputStream.println("End");
        writeOutputStream.println(freenetURI.toString());
        writeOutputStream.close();
        return fileBucket;
    }

    protected static File makeRedirect(FreenetURI freenetURI) throws IOException {
        return ClientUtil.makeRedirectBucket(freenetURI).getFile();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

