/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.client.ClientEvent;
import Freenet.client.ClientEventListener;
import Freenet.client.events.ExceptionEvent;
import Freenet.client.events.StateReachedEvent;
import java.util.Stack;

public class DoneListener
implements ClientEventListener {
    private Stack exceptions = new Stack();
    private boolean isComplete = false;

    public void waitEvent() throws InterruptedException {
        DoneListener doneListener = this;
        synchronized (doneListener) {
            while (!this.isComplete) {
                this.wait();
            }
        }
    }

    public void receive(ClientEvent clientEvent) {
        if (clientEvent instanceof StateReachedEvent) {
            StateReachedEvent stateReachedEvent = (StateReachedEvent)clientEvent;
            if (stateReachedEvent.getState() == -1 || stateReachedEvent.getState() == 4) {
                DoneListener doneListener = this;
                synchronized (doneListener) {
                    this.isComplete = true;
                    this.notifyAll();
                }
            }
        } else if (clientEvent instanceof ExceptionEvent) {
            try {
                ((ExceptionEvent)clientEvent).rethrow();
            }
            catch (Exception exception) {
                this.exceptions.push(exception);
            }
        }
    }

    public Exception[] getExceptions() {
        if (this.exceptions.empty()) {
            return null;
        }
        Object[] objectArray = new Exception[this.exceptions.size()];
        this.exceptions.copyInto(objectArray);
        return objectArray;
    }
}

